//------------------------------------------------------------------------------
// AiboCamera.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using attributes = Microsoft.Dss.Core.Attributes;
using Microsoft.Ccr.Core;
using dssaibocamera = Cornell.Cs100r.Robotics.DssAiboCamera;
using permissions = System.Security.Permissions;
using svcbase = Microsoft.Dss.ServiceModel.DsspServiceBase;
using dssp = Microsoft.Dss.ServiceModel.Dssp;

using System.Drawing;
using System.Net;
using System.Net.Mime;
using System.IO;
using Cornell.Cs100r.Robotics.LogoApi;
using Microsoft.Dss.Core.DsspHttp;
using Microsoft.Dss.Core.DsspHttpUtilities;

using Cornell.Cs100r.Robotics.LogoApi.Proxy;

namespace Cornell.Cs100r.Robotics.DssAiboCamera
{
    
    [attributes.Contract(Contract.Namespace)]
    [permissions.PermissionSet(permissions.SecurityAction.PermitOnly, Name="FullTrust")]
    public class AiboCamera : svcbase.DsspServiceBase
    {
        private StateType _state = new StateType();
        [attributes.ServicePort("/aibocamera", AllowMultipleInstances=false)]
        private AiboCameraOperations _mainPort = new AiboCameraOperations();

        private DsspHttpUtilitiesPort _httpUtilsPort;

        public AiboCamera(dssp.DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
			CreateSuccess();
        }
        protected override void Start()
        {
            _httpUtilsPort = DsspHttpUtilitiesService.Create(this.Environment);

            // Listen on the main port for requests and call the appropriate handler.

            Activate(
                Arbiter.Interleave(
                    new TeardownReceiverGroup(
                        Arbiter.Receive<dssp.DsspDefaultDrop>(false, _mainPort, DefaultDropHandler)
                    ),
                    new ExclusiveReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<Replace>(true, _mainPort, ReplaceHandler),
                        Arbiter.ReceiveWithIterator<Subscribe>(true, _mainPort, SubscribeHandler)
                    ),
                    new ConcurrentReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<Get>(true, _mainPort, GetHandler),
                        Arbiter.Receive<dssp.DsspDefaultLookup>(true, _mainPort, DefaultLookupHandler),
                        Arbiter.Receive<GrabFrame>(true, _mainPort, GrabFrameHandler),
                        Arbiter.Receive<HttpGet>(true, _mainPort, HttpGetHandler)
                    ))
            );


            // Insert ourselves into the directory so that others can find us
            DirectoryInsert();

            // Display browser accesible Service URI
            LogInfo("Service uri: " + ServiceInfo.Service);
        }
        private IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
        private IEnumerator<ITask> ReplaceHandler(Replace replace)
        {
            _state = replace.Body;
            replace.ResponsePort.Post(dssp.DefaultReplaceResponseType.Instance);
            yield break;
        }
        private IEnumerator<ITask> SubscribeHandler(Subscribe subscribe)
        {
            yield break;
        }

        private void GrabFrameHandler(GrabFrame gf)
        {
            try
            {                
                gf.ResponsePort.Post(makeMyBitmap(FrameGrabber.getFrame(gf.Body.address)));
            }
            catch (Exception e)
            {
                Fault f = new Fault();
                f.Message = "Exception thrown while grabbing frame: " + e.ToString();
                gf.ResponsePort.Post(f);
                return;
            }
        }

        private void HttpGetHandler(HttpGet hg)
        {
            HttpListenerRequest request = hg.Body.Context.Request;
            string path = request.Url.AbsolutePath;

            if (path.StartsWith("/aibocamera/grabframe/"))
            {
                path = path.Replace("/aibocamera/grabframe/", "");
                Bitmap img = FrameGrabber.getFrame(path);
                Stream s = streamifyBitmap(img, System.Drawing.Imaging.ImageFormat.Jpeg);
                SendJpeg(hg.Body.Context, s);
            }
        }

        private Stream streamifyBitmap(Bitmap bmp, System.Drawing.Imaging.ImageFormat fmt)
        {
            MemoryStream memory = new MemoryStream();
            bmp.Save(memory, fmt);
            memory.Position = 0;
            return memory;
        }

        
        static MyBitmap makeMyBitmap(System.Drawing.Bitmap oldbmp)
        {
            MyBitmap mybmp = new MyBitmap();
            oldbmp.Save(mybmp.data, System.Drawing.Imaging.ImageFormat.Bmp);
            mybmp.data.Position = 0;
            return mybmp;
        }

        /* Stolen from the SickLRF sample */
        private void SendJpeg(HttpListenerContext context, Stream stream)
        {
            WriteResponseFromStream write = new WriteResponseFromStream(context, stream, MediaTypeNames.Image.Jpeg);

            _httpUtilsPort.Post(write);

            Activate(
                Arbiter.Choice(
                    write.ResultPort,
                    delegate(Stream res)
                    {
                        stream.Close();
                    },
                    delegate(Exception e)
                    {
                        stream.Close();
                        LogError(e);
                    }
                )
            );
        }

    }
}
