function [out ] = robotCommand(varargin)
	global robotUrl;

	if(nargin < 1)
		error('cant sent command without function name');
	end

	str = [ 'function=' cell2mat(varargin(1)) ];		

	for i = 2:2:nargin
		str = [str '&' cell2mat(varargin(i)) '=' cell2mat(varargin(i+1)) ];
	end
	%disp(str)

	if(isempty(robotUrl))
		error('must call robotInit before robotCommand');
	end

	[status, out, hdrs ] = httpPost(str, robotUrl);
	if(~status)
		error('did not receive HTTP 200 from robot');
	end
