function [status,rd,hdrs] = httpPost(data, addrDest)
url = java.net.URL(addrDest);
sock = java.net.Socket(url.getHost(), url.getPort());
out = java.io.OutputStreamWriter(sock.getOutputStream(), 'UTF-8');
header = sprintf('POST %s HTTP/1.1\n', char(url.getPath()));
header = sprintf('%sHost: %s\n', header, char(url.getHost()));
header = sprintf('%sContent-Type: application/x-www-form-urlencoded\nConnection: close\n', header);
header = sprintf('%sContent-Length: %d\n\n', header, length(data));

%disp([header data]);
out.write(header);
out.write(data);
out.flush();

in = java.io.BufferedReader(java.io.InputStreamReader(sock.getInputStream()));
response = char(in.readLine());
[code, remainder] = strtok(response);
[code, remainder] = strtok(remainder);
status = strcmp(code, '200');

%first read back headers
hdr = char(in.readLine());
i = 1;
while(length(hdr))
    [ hk, rem ] = strtok(hdr, ':');
    hv = rem(3:length(rem));
    
    hdrs(i).name = hk;
    hdrs(i).value = hv;
    hdr = char(in.readLine());
    i=i+1;
end

rd = '';
while(in.ready())
    rd = [char(in.readLine()) 10];
end

out.close();
in.close();
sock.close();
