/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.util;

import edu.cornell.cs.cs100r.util.TransformationListener;
import java.util.HashSet;
import javax.media.opengl.GL;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Transformable {
    Matrix4d m_transformation = new Matrix4d();
    double[] m_matrix = new double[16];
    Matrix4d m_temporary = new Matrix4d();
    private AxisAngle4d m_rotation = new AxisAngle4d();
    HashSet<TransformationListener> m_listeners = new HashSet();

    public Transformable() {
        this.m_transformation.setIdentity();
    }

    public void copy(Transformable b) {
        this.m_transformation.set(b.m_transformation);
        this.notifyListeners();
    }

    public void setScale(double amt) {
        this.m_transformation.setScale(amt);
    }

    public void setRotation(Vector3d axis, double angle) {
        this.m_rotation.set(axis, angle);
        this.m_transformation.setRotation(this.m_rotation);
        this.notifyListeners();
    }

    public void setTranslation(double x, double y, double z) {
        this.m_transformation.setTranslation(new Vector3d(x, y, z));
        this.notifyListeners();
    }

    public void setTranslation(Vector3d x) {
        this.m_transformation.setTranslation(x);
        this.notifyListeners();
    }

    public void mul(Matrix4d m) {
        this.m_transformation.mul(m);
        this.notifyListeners();
    }

    public void getTranslation(Vector3d x_out) {
        x_out.x = this.m_transformation.m03;
        x_out.y = this.m_transformation.m13;
        x_out.z = this.m_transformation.m23;
    }

    public void transform(Vector3d x) {
        this.m_transformation.transform(x);
    }

    public void transform(Point3d x) {
        this.m_transformation.transform(x);
    }

    public void apply(GL gl) {
        gl.glMatrixMode(5888);
        this.m_matrix[0] = this.m_transformation.m00;
        this.m_matrix[1] = this.m_transformation.m10;
        this.m_matrix[2] = this.m_transformation.m20;
        this.m_matrix[3] = this.m_transformation.m30;
        this.m_matrix[4] = this.m_transformation.m01;
        this.m_matrix[5] = this.m_transformation.m11;
        this.m_matrix[6] = this.m_transformation.m21;
        this.m_matrix[7] = this.m_transformation.m31;
        this.m_matrix[8] = this.m_transformation.m02;
        this.m_matrix[9] = this.m_transformation.m12;
        this.m_matrix[10] = this.m_transformation.m22;
        this.m_matrix[11] = this.m_transformation.m32;
        this.m_matrix[12] = this.m_transformation.m03;
        this.m_matrix[13] = this.m_transformation.m13;
        this.m_matrix[14] = this.m_transformation.m23;
        this.m_matrix[15] = this.m_transformation.m33;
        gl.glMultMatrixd(this.m_matrix, 0);
    }

    public void addListener(TransformationListener x) {
        this.m_listeners.add(x);
    }

    public void removeListener(TransformationListener x) {
        if (this.m_listeners.contains(x)) {
            this.m_listeners.remove(x);
        }
    }

    protected void notifyListeners() {
        for (TransformationListener listener : this.m_listeners) {
            listener.updateTransformation(this);
        }
    }

    protected void drawObject(GL gl) {
    }

    public void draw(GL gl) {
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        this.apply(gl);
        this.drawObject(gl);
        gl.glPopMatrix();
    }
}

