/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.util;

import edu.cornell.cs.cs100r.util.Camera;
import edu.cornell.cs.cs100r.util.Transformable;
import edu.cornell.cs.cs100r.util.TransformationListener;
import javax.media.opengl.GL;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class StaticCamera
implements TransformationListener,
Camera {
    protected Point3d m_eye = new Point3d(0.0, 0.0, 0.0);
    protected Vector3d m_up = new Vector3d(0.0, 1.0, 0.0);
    protected Vector3d m_look = new Vector3d(0.0, 0.0, 1.0);
    protected Transformable m_reference;
    protected Point3d m_e = new Point3d();
    protected Vector3d m_f = new Vector3d();
    protected Vector3d m_u = new Vector3d();
    protected Vector3d m_s = new Vector3d();
    protected double[] m_matrix = new double[16];

    public StaticCamera() {
        this.compute();
    }

    public StaticCamera(Point3d eye, Vector3d up, Vector3d look) {
        this.set(eye, up, look);
    }

    public void setReferenceFrame(Transformable reference) {
        if (this.m_reference != null) {
            this.m_reference.removeListener((TransformationListener)this);
        }
        this.m_reference = reference;
        reference.addListener((TransformationListener)this);
    }

    public void set(Point3d eye, Vector3d up, Vector3d look) {
        this.m_eye = eye;
        this.m_up = up;
        this.m_look = look;
        this.compute();
    }

    public void setEye(Point3d eye) {
        this.m_eye = eye;
        this.compute();
    }

    public void getEye(Point3d eye_out) {
        eye_out.set((Tuple3d)this.m_eye);
    }

    public void setEye(double x, double y, double z) {
        this.m_eye.x = x;
        this.m_eye.y = y;
        this.m_eye.z = z;
        this.compute();
    }

    public void setUp(Vector3d up) {
        this.m_up = up;
        this.compute();
    }

    public void setUp(double x, double y, double z) {
        this.m_up.x = x;
        this.m_up.y = y;
        this.m_up.z = z;
        this.compute();
    }

    public void setLook(Vector3d look) {
        this.m_look = look;
        this.compute();
    }

    public void setLook(double x, double y, double z) {
        this.m_look.x = x;
        this.m_look.y = y;
        this.m_look.z = z;
        this.compute();
    }

    public void setLookAt(double x, double y, double z) {
        this.m_look.x = x - this.m_eye.x;
        this.m_look.y = y - this.m_eye.y;
        this.m_look.z = z - this.m_eye.z;
        this.compute();
    }

    protected void compute() {
        this.m_f.set((Tuple3d)this.m_look);
        this.m_u.set((Tuple3d)this.m_up);
        this.m_e.set((Tuple3d)this.m_eye);
        if (this.m_reference != null) {
            this.m_reference.transform(this.m_f);
            this.m_reference.transform(this.m_u);
            this.m_reference.transform(this.m_e);
        }
        this.m_f.normalize();
        this.m_u.normalize();
        this.m_s.cross(this.m_f, this.m_u);
        this.m_u.cross(this.m_s, this.m_f);
        this.m_matrix[0] = this.m_s.x;
        this.m_matrix[1] = this.m_u.x;
        this.m_matrix[2] = -this.m_f.x;
        this.m_matrix[3] = 0.0;
        this.m_matrix[4] = this.m_s.y;
        this.m_matrix[5] = this.m_u.y;
        this.m_matrix[6] = -this.m_f.y;
        this.m_matrix[7] = 0.0;
        this.m_matrix[8] = this.m_s.z;
        this.m_matrix[9] = this.m_u.z;
        this.m_matrix[10] = -this.m_f.z;
        this.m_matrix[11] = 0.0;
        this.m_matrix[12] = 0.0;
        this.m_matrix[13] = 0.0;
        this.m_matrix[14] = 0.0;
        this.m_matrix[15] = 1.0;
    }

    public void updateTransformation(Transformable t) {
        this.compute();
    }

    public void apply(GL gl) {
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glMultMatrixd(this.m_matrix, 0);
        gl.glTranslated(-this.m_e.x, -this.m_e.y, -this.m_e.z);
    }
}

