/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.robotArena.arena;

import edu.cornell.cs.cs100r.robotArena.CollisionHandler;
import edu.cornell.cs.cs100r.robotArena.arena.Arena;
import edu.cornell.cs.cs100r.robotArena.arena.ArenaObject;
import edu.cornell.cs.cs100r.robotArena.robot.Robot;
import edu.cornell.cs.cs100r.util.Camera;
import edu.cornell.cs.cs100r.util.StaticCamera;
import edu.cornell.cs.cs100r.util.Transformable;
import javax.media.opengl.GL;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SimpleArena
extends Arena {
    public Point3d _p1;
    public Point3d _p2;
    protected CollisionHandler collisionHandler = new CollisionHandler();
    public StaticCamera _ceilingCamera = new StaticCamera();
    protected boolean _drawGrid = true;
    protected boolean _drawTrails = true;
    float t = 0.0f;

    public SimpleArena() {
        this._p1 = new Point3d(0.0, 0.0, 0.0);
        this._p2 = new Point3d(1.0, 0.1, 1.0);
        this._ceilingCamera.setReferenceFrame((Transformable)this);
        this._ceilingCamera.setEye(0.0, 0.5, 0.5);
        this._ceilingCamera.setUp(0.0, 1.0, 0.0);
        this._ceilingCamera.setLookAt(0.0, 0.0, 0.0);
        this.add(new Robot((Arena)this, new Vector3d(0.7, 0.0, 0.7), 4.0, 0.3, 0.5, true));
    }

    public void drawArena(GL gl) {
        gl.glBegin(7);
        gl.glColor3d(0.7, 0.7, 0.7);
        gl.glVertex3d(this._p1.x, this._p1.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p1.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p1.y, this._p2.z);
        gl.glVertex3d(this._p1.x, this._p1.y, this._p2.z);
        gl.glColor3d(0.6, 0.6, 0.6);
        gl.glVertex3d(this._p1.x, this._p1.y, this._p1.z);
        gl.glVertex3d(this._p1.x, this._p2.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p2.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p1.y, this._p1.z);
        gl.glVertex3d(this._p1.x, this._p1.y, this._p2.z);
        gl.glVertex3d(this._p2.x, this._p1.y, this._p2.z);
        gl.glVertex3d(this._p2.x, this._p2.y, this._p2.z);
        gl.glVertex3d(this._p1.x, this._p2.y, this._p2.z);
        gl.glVertex3d(this._p1.x, this._p1.y, this._p1.z);
        gl.glVertex3d(this._p1.x, this._p1.y, this._p2.z);
        gl.glVertex3d(this._p1.x, this._p2.y, this._p2.z);
        gl.glVertex3d(this._p1.x, this._p2.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p1.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p2.y, this._p1.z);
        gl.glVertex3d(this._p2.x, this._p2.y, this._p2.z);
        gl.glVertex3d(this._p2.x, this._p1.y, this._p2.z);
        gl.glEnd();
        if (this._drawGrid) {
            gl.glBegin(1);
            gl.glColor3d(0.5, 0.5, 1.0);
            double x = this._p1.x;
            while (x < this._p2.x) {
                gl.glVertex3d(x, this._p1.y + 0.005, this._p1.z);
                gl.glVertex3d(x, this._p1.y + 0.005, this._p2.z);
                x += 0.1;
            }
            double z = this._p1.z;
            while (z < this._p2.z) {
                gl.glVertex3d(this._p1.x, this._p1.y + 5.0E-4, z);
                gl.glVertex3d(this._p2.x, this._p1.y + 5.0E-4, z);
                z += 0.1;
            }
            gl.glVertex3d(this._p1.x + 0.001, this._p1.y, this._p1.z + 0.001);
            gl.glVertex3d(this._p1.x + 0.001, this._p2.y, this._p1.z + 0.001);
            gl.glVertex3d(this._p2.x - 0.001, this._p1.y, this._p2.z - 0.001);
            gl.glVertex3d(this._p2.x - 0.001, this._p2.y, this._p2.z - 0.001);
            gl.glVertex3d(this._p2.x - 0.001, this._p1.y, this._p1.z + 0.001);
            gl.glVertex3d(this._p2.x - 0.001, this._p2.y, this._p1.z + 0.001);
            gl.glVertex3d(this._p1.x + 0.001, this._p1.y, this._p2.z - 0.001);
            gl.glVertex3d(this._p1.x + 0.001, this._p2.y, this._p2.z - 0.001);
            gl.glEnd();
        }
        if (this._drawTrails) {
            for (Robot r : this._robots) {
                r.drawLines(gl);
            }
        }
    }

    public Camera getMainCamera() {
        return this._ceilingCamera;
    }

    public void update(float delta) {
        int i = 0;
        while (i < this._robots.size()) {
            Robot r = (Robot)this._robots.get(i);
            Vector3d v = new Vector3d(r.speed * (double)delta, 0.0, 0.0);
            Vector3d u = new Vector3d();
            r.getTranslation(u);
            r.setRotation(r.currentRotation + r.rotationSpeed * (double)delta);
            r.transform(v);
            v.add((Tuple3d)u);
            Robot test = new Robot((Arena)this, v, 0.0, 0.0, 0.0, false);
            boolean collided = false;
            if (this.collisionHandler.hasCollided(test, this._p2).booleanValue()) {
                if (this.pong) {
                    r.speed = -r.speed;
                    collided = true;
                } else {
                    r.freeze();
                    collided = true;
                }
            }
            if (!collided) {
                if (this.pong) {
                    r.setRotation(r.currentRotation + r.rotationSpeed * (double)delta);
                }
                double went = Math.abs(r.speed) * (double)delta;
                r.distanceTraveled += went;
                r.toGo -= went;
                if (r.toGo - -1000.0 < 0.01 || r.toGo > 0.0) {
                    r.setTranslation(v);
                    Point3d p = new Point3d();
                    p.add((Tuple3d)v);
                    r.points1.add(p);
                } else {
                    r.freeze();
                }
            }
            ++i;
        }
    }

    public boolean add(Robot rob) {
        if (this.collisionHandler.hasCollided(rob, this._p2).booleanValue()) {
            return false;
        }
        int j = 0;
        while (j < this._objects.size()) {
            if (this.collisionHandler.hasCollided(rob, (ArenaObject)this._objects.get(j))) {
                return false;
            }
            ++j;
        }
        this._objects.add(rob);
        this._robots.add(rob);
        return true;
    }
}

