/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.robotArena.arena;

import edu.cornell.cs.cs100r.robotArena.arena.ArenaObject;
import edu.cornell.cs.cs100r.robotArena.robot.Robot;
import edu.cornell.cs.cs100r.util.Camera;
import edu.cornell.cs.cs100r.util.Transformable;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;

public abstract class Arena
extends Transformable {
    protected boolean pong = false;
    protected List<ArenaObject> _objects = new ArrayList();
    protected List<Robot> _robots = new ArrayList();

    public boolean getPong() {
        return this.pong;
    }

    public void setPong(boolean p) {
        this.pong = p;
    }

    public int getNumObjects() {
        return this._objects.size();
    }

    public ArenaObject getArenaObjectAt(int i) {
        return (ArenaObject)this._objects.get(i);
    }

    public int getNumRobots() {
        return this._robots.size();
    }

    public Robot getRobotAt(int i) {
        return (Robot)this._robots.get(i);
    }

    public abstract void drawArena(GL var1);

    public abstract Camera getMainCamera();

    public abstract void update(float var1);

    public void draw(GL gl) {
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        this.apply(gl);
        this.drawArena(gl);
        for (ArenaObject object : this._objects) {
            gl.glPushMatrix();
            object.draw(gl);
            gl.glPopMatrix();
        }
        gl.glPopMatrix();
    }

    public boolean add(ArenaObject obj) {
        if (obj instanceof Robot) {
            this.add((Robot)obj);
        } else {
            this._objects.add(obj);
        }
        return true;
    }

    public boolean add(Robot rob) {
        this._objects.add(rob);
        this._robots.add(rob);
        return true;
    }
}

