/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.robotArena;

import edu.cornell.cs.cs100r.robotArena.arena.ArenaBox;
import edu.cornell.cs.cs100r.robotArena.arena.ArenaObject;
import edu.cornell.cs.cs100r.robotArena.robot.Robot;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class CollisionHandler {
    public boolean hasCollided(Robot r, ArenaObject j) {
        if (j instanceof ArenaBox) {
            ArenaBox k = (ArenaBox)j;
            return this.hasCollided(r, k);
        }
        if (j instanceof Robot) {
            Robot l = (Robot)j;
            return this.hasCollided(r, l);
        }
        return false;
    }

    public boolean hasCollided(Robot r, ArenaBox j) {
        ArrayList<Point3d> p1List = new ArrayList<Point3d>();
        ArrayList<Point3d> p2List = new ArrayList<Point3d>();
        Point3d a = new Point3d(0.0, 0.0, 0.0);
        Point3d b = new Point3d(0.0, 0.0, j._p2.getZ());
        Point3d c = new Point3d(j._p2.getX(), 0.0, j._p2.getZ());
        Point3d d = new Point3d(j._p2.getX(), 0.0, 0.0);
        j.transform(a);
        j.transform(b);
        j.transform(c);
        j.transform(d);
        p1List.add(a);
        p2List.add(b);
        p1List.add(b);
        p2List.add(c);
        p1List.add(c);
        p2List.add(d);
        p1List.add(d);
        p2List.add(a);
        int i = 0;
        while (i < p1List.size()) {
            double vx = ((Point3d)p1List.get(i)).getX() - ((Point3d)p2List.get(i)).getX();
            double vy = ((Point3d)p1List.get(i)).getY() - ((Point3d)p2List.get(i)).getY();
            double vz = ((Point3d)p1List.get(i)).getZ() - ((Point3d)p2List.get(i)).getZ();
            Vector3d lineSeg = new Vector3d(-1.0 * vx, -1.0 * vy, -1.0 * vz);
            Vector3d botLoc = new Vector3d();
            r.getTranslation(botLoc);
            vx = ((Point3d)p1List.get(i)).getX() - botLoc.getX();
            vy = ((Point3d)p1List.get(i)).getY() - botLoc.getY();
            vz = ((Point3d)p1List.get(i)).getZ() - botLoc.getZ();
            Vector3d botSeg = new Vector3d(-1.0 * vx, -1.0 * vy, -1.0 * vz);
            double t = lineSeg.dot(botSeg) / lineSeg.dot(lineSeg);
            double distance = 0.0;
            if (t <= 0.0) {
                distance = botSeg.length();
            }
            if (t > 0.0 && t < 1.0) {
                Point3d linePoint = new Point3d(((Point3d)p1List.get(i)).getX() + t * lineSeg.getX(), ((Point3d)p1List.get(i)).getY() + t * lineSeg.getY(), ((Point3d)p1List.get(i)).getZ() + t * lineSeg.getZ());
                Vector3d w = new Vector3d(botLoc.getX() - linePoint.getX(), botLoc.getY() - linePoint.getY(), botLoc.getZ() - linePoint.getZ());
                distance = w.length();
            }
            if (t >= 1.0) {
                Vector3d w = new Vector3d(botLoc.getX() - ((Point3d)p2List.get(i)).getX(), botLoc.getY() - ((Point3d)p2List.get(i)).getY(), botLoc.getZ() - ((Point3d)p2List.get(i)).getZ());
                distance = w.length();
            }
            if (distance <= 0.05) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Boolean hasCollided(Robot r, Robot j) {
        Vector3d v = new Vector3d();
        Vector3d u = new Vector3d();
        r.getTranslation(v);
        j.getTranslation(u);
        Point3d p = new Point3d(v.getX(), v.getY(), v.getZ());
        Point3d q = new Point3d(u.getX(), u.getY(), u.getZ());
        double distance = p.distance(q);
        if (distance < 0.1) {
            return true;
        }
        return false;
    }

    public Boolean hasCollided(Robot r, Point3d p) {
        Vector3d v = new Vector3d(p.getX(), p.getY(), p.getZ());
        ArenaBox b = new ArenaBox((Tuple3d)v, new Vector3d(0.0, 0.0, 0.0), 0.0);
        return this.hasCollided(r, b);
    }
}

