/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.util;

import edu.cornell.cs.cs100r.util.Camera;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class TrackballCamera
implements Camera {
    private Vector3d u1;
    private Vector3d u2 = new Vector3d();
    private Vector3d v = new Vector3d();
    private AxisAngle4d mouseRotation = new AxisAngle4d();
    private Matrix4d mouseRotationDiff = new Matrix4d();
    private Matrix4d trackballRotation = new Matrix4d();
    private double[] trackballMatrix = new double[16];
    private GLU glu = new GLU();
    protected Vector3d target = new Vector3d();
    protected double radius = 1.0;

    public TrackballCamera() {
        this.trackballRotation.setIdentity();
        this.mouseRotationDiff.setIdentity();
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setTarget(double x, double y, double z) {
        this.target.set(x, y, z);
    }

    public void getTarget(Vector3d out) {
        out.set(this.target);
    }

    public void trackballRelease() {
        this.u1 = null;
    }

    public void setRotation(AxisAngle4d r) {
        this.trackballRotation.setRotation(r);
    }

    public void trackballMouse(double inX, double inY, double width, double height) {
        double x = inX - width / 2.0;
        double y = height - inY - height / 2.0;
        double mouseRSquared = x * x + y * y;
        double RSquared = Math.max(width * width / 4.0, height * height / 4.0);
        if (mouseRSquared > RSquared) {
            x *= Math.sqrt(RSquared / mouseRSquared);
            y *= Math.sqrt(RSquared / mouseRSquared);
        }
        double r = Math.sqrt(RSquared);
        this.u2.set(x / r, y / r, Math.sqrt(1.001 - x * x / RSquared - y * y / RSquared));
        if (this.u1 == null) {
            this.u1 = this.u2;
            this.u2 = new Vector3d();
            return;
        }
        this.v.cross(this.u1, this.u2);
        if (this.v.length() == 0.0) {
            return;
        }
        double l = Math.asin(this.v.length());
        this.v.normalize();
        this.mouseRotation.set(this.v, l);
        this.mouseRotationDiff.setRotation(this.mouseRotation);
        this.mouseRotationDiff.mul(this.trackballRotation);
        this.trackballRotation.set(this.mouseRotationDiff);
        Vector3d temp = this.u1;
        this.u1 = this.u2;
        this.u2 = temp;
    }

    private void applyTrackball(GL gl) {
        gl.glMatrixMode(5888);
        this.trackballMatrix[0] = this.trackballRotation.m00;
        this.trackballMatrix[1] = this.trackballRotation.m10;
        this.trackballMatrix[2] = this.trackballRotation.m20;
        this.trackballMatrix[3] = this.trackballRotation.m30;
        this.trackballMatrix[4] = this.trackballRotation.m01;
        this.trackballMatrix[5] = this.trackballRotation.m11;
        this.trackballMatrix[6] = this.trackballRotation.m21;
        this.trackballMatrix[7] = this.trackballRotation.m31;
        this.trackballMatrix[8] = this.trackballRotation.m02;
        this.trackballMatrix[9] = this.trackballRotation.m12;
        this.trackballMatrix[10] = this.trackballRotation.m22;
        this.trackballMatrix[11] = this.trackballRotation.m32;
        this.trackballMatrix[12] = this.trackballRotation.m03;
        this.trackballMatrix[13] = this.trackballRotation.m13;
        this.trackballMatrix[14] = this.trackballRotation.m23;
        this.trackballMatrix[15] = this.trackballRotation.m33;
        gl.glMultMatrixd(this.trackballMatrix, 0);
    }

    public void apply(GL gl) {
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.glu.gluLookAt(0.0, 0.0, this.radius, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.applyTrackball(gl);
        gl.glTranslated(-this.target.x, -this.target.y, -this.target.z);
    }
}

