/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.robotArena.robot;

import edu.cornell.cs.cs100r.robotArena.arena.Arena;
import edu.cornell.cs.cs100r.robotArena.arena.ArenaObject;
import edu.cornell.cs.cs100r.util.StaticCamera;
import java.io.IOException;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;

public class Robot
extends ArenaObject
implements XmlRpcHandler,
XmlRpcHandlerMapping {
    private static int portNumber = 8000;
    public double currentRotation;
    public double speed;
    public double rotationSpeed;
    protected boolean flushMode = true;
    public Vector<Point3d> points1;
    public Vector<Point3d> points2;
    public double distanceTraveled;
    public static final double SCALE = 3.2808398950131233E-4;
    public static final double TOGODEF = -1000.0;
    public double toGo;
    protected Arena myArena;
    protected StaticCamera myCamera;
    public GLU glu = new GLU();
    public GLUquadric quadric;
    private WebServer webServer;
    private int port;

    public Robot(Arena arena, Vector3d v, double r, double s, double rs, boolean attachServer) {
        this.setTranslation(v);
        this.setRotation(r);
        this.speed = s;
        this.rotationSpeed = rs;
        this.points1 = new Vector();
        this.points2 = new Vector();
        this.distanceTraveled = 0.0;
        this.toGo = -1000.0;
        this.myArena = arena;
        this.myCamera = new StaticCamera(new Point3d(0.04, 0.0, 0.025), new Vector3d(0.0, 1.0, 0.0), new Vector3d(1.0, 0.0, 0.0));
        this.myCamera.setReferenceFrame(this);
        if (attachServer) {
            this.port = Robot.getNextPortNumber();
            this.webServer = new WebServer(this.port);
            XmlRpcStreamServer server = this.webServer.getXmlRpcServer();
            server.setHandlerMapping(this);
            try {
                this.webServer.start();
            }
            catch (IOException e) {
                System.out.println("Unable to listen for XMLRPC requests.");
                e.printStackTrace();
            }
        }
    }

    private static int getNextPortNumber() {
        return ++portNumber - 1;
    }

    protected void drawObject(GL gl) {
        if (this.quadric == null) {
            this.quadric = this.glu.gluNewQuadric();
        }
        gl.glMatrixMode(5888);
        gl.glColor3d(0.9, 0.9, 0.9);
        gl.glRotated(-90.0, 1.0, 0.0, 0.0);
        this.glu.gluDisk(this.quadric, 0.0, 0.0505, 15, 1);
        gl.glColor3d(0.85, 0.85, 0.85);
        this.glu.gluCylinder(this.quadric, 0.05, 0.05, 0.02, 16, 1);
        gl.glColor3d(0.9, 0.9, 0.9);
        gl.glTranslated(0.0, 0.0, 0.02);
        this.glu.gluDisk(this.quadric, 0.0, 0.0505, 15, 1);
        gl.glColor3d(0.0, 0.0, 0.0);
        gl.glTranslated(0.03, 0.0, 0.005);
        this.glu.gluSphere(this.quadric, 0.01, 8, 8);
    }

    public void drawLines(GL gl) {
        gl.glColor3d(1.0, 1.0, 1.0);
        gl.glBegin(1);
        int i = 0;
        while (i + 1 < this.points1.size()) {
            gl.glVertex3d(this.points1.get((int)i).x, this.points1.get((int)i).y + 0.01, this.points1.get((int)i).z);
            gl.glVertex3d(this.points1.get((int)(i + 1)).x, this.points1.get((int)(i + 1)).y + 0.01, this.points1.get((int)(i + 1)).z);
            ++i;
        }
        gl.glEnd();
        gl.glBegin(1);
        i = 0;
        while (i + 1 < this.points2.size()) {
            gl.glVertex3d(this.points2.get((int)i).x, this.points2.get((int)i).y + 0.01, this.points2.get((int)i).z + 0.01);
            gl.glVertex3d(this.points2.get((int)(i + 1)).x, this.points2.get((int)(i + 1)).y + 0.01, this.points2.get((int)(i + 1)).z + 0.01);
            ++i;
        }
        gl.glEnd();
    }

    public void setRotation(double r) {
        this.currentRotation = r;
        super.setRotation(new Vector3d(0.0, 1.0, 0.0), r);
    }

    public void freeze() {
        this.speed = 0.0;
        this.rotationSpeed = 0.0;
    }

    public void unfreeze() {
        this.speed = 0.5 * Math.random() + 0.5;
        this.rotationSpeed = 2.0 * Math.random();
    }

    public XmlRpcHandler getHandler(String handlerName) {
        return this;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        System.out.println(req.getMethodName());
        if (req.getMethodName().equals("driveCircle")) {
            double velocity = (Double)req.getParameter(0);
            double radius = (Double)req.getParameter(1);
            double distance = (Double)req.getParameter(2);
            this.speed = 3.2808398950131233E-4 * Math.copySign(Math.min(Math.abs(velocity), 1000.0), velocity);
            if (radius < 1.0E-7) {
                radius = 1.0E-7;
            }
            try {
                this.rotationSpeed = velocity / radius;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (this.flushMode) {
                this.points1 = new Vector();
                this.points2 = new Vector();
            }
            this.distanceTraveled = 0.0;
            this.toGo = 3.2808398950131233E-4 * distance;
            return "";
        }
        if (req.getMethodName().equals("driveStraight")) {
            double velocity = (Double)req.getParameter(0);
            double distance = (Double)req.getParameter(1);
            this.speed = 3.2808398950131233E-4 * Math.copySign(Math.min(Math.abs(velocity), 1000.0), velocity);
            this.rotationSpeed = 0.0;
            if (this.flushMode) {
                this.points1 = new Vector();
                this.points2 = new Vector();
            }
            this.distanceTraveled = 0.0;
            this.toGo = 3.2808398950131233E-4 * distance;
            return "";
        }
        if (req.getMethodName().equals("robotTurn")) {
            double toRotate = (Double)req.getParameter(0);
            toRotate = toRotate / 360.0 * 2.0 * Math.PI;
            this.setRotation(this.currentRotation + toRotate);
            return "";
        }
        if (req.getMethodName().equals("getFrame")) {
            return "";
        }
        if (req.getMethodName().equals("getSensors")) {
            return "";
        }
        if (req.getMethodName().equals("setMode")) {
            return "";
        }
        if (req.getMethodName().equals("driveDirect")) {
            double leftVelocity = Math.min(3.2808398950131233E-4 * (Double)req.getParameter(0), 1000.0);
            double rightVelocity = Math.min(3.2808398950131233E-4 * (Double)req.getParameter(1), 1000.0);
            this.speed = (rightVelocity + leftVelocity) / 2.0;
            this.rotationSpeed = (rightVelocity - leftVelocity) / 2.0;
            if (this.flushMode) {
                this.points1 = new Vector();
                this.points2 = new Vector();
            }
            this.distanceTraveled = 0.0;
            this.toGo = -1000.0;
            return "";
        }
        if (req.getMethodName().equals("example")) {
            return "This is Robot " + Integer.toString(this.port) + " speaking!";
        }
        if (req.getMethodName().equals("status")) {
            return "This is Robot" + Integer.toString(this.port) + "speaking!\n" + "  speed is " + Double.toString(this.speed) + "\n" + "  rotation is " + Double.toString(this.rotationSpeed) + "\n" + "  this arena has " + Integer.toString(this.myArena.getNumRobots()) + " robots and " + Integer.toString(this.myArena.getNumObjects()) + " total objects.";
        }
        throw new XmlRpcException(0, "Unrecognized method name: " + req.getMethodName());
    }
}

