/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.robotArena;

import edu.cornell.cs.cs100r.robotArena.arena.Arena;
import edu.cornell.cs.cs100r.util.TrackballCamera;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.vecmath.AxisAngle4d;

public class MainEventHandler
implements GLEventListener,
KeyListener,
MouseListener,
MouseMotionListener {
    Arena _arena;
    GLCanvas _canvas;
    TrackballCamera _camera = new TrackballCamera();
    protected GLU _glu = null;
    double _width = 640.0;
    double _height = 480.0;
    double _lastMouseY = 0.0;
    boolean _mouseValid = false;

    public MainEventHandler(Arena arena, GLCanvas canvas) {
        this._arena = arena;
        this._canvas = canvas;
        canvas.addGLEventListener(this);
        canvas.addKeyListener(this);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        this._camera.setTarget(0.5, 0.0, 0.5);
        this._camera.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, 0.7853981633974483));
    }

    public void initGL(GL gl) {
        gl.glShadeModel(7425);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        gl.glLineWidth(2.0f);
    }

    public synchronized void display(GLAutoDrawable target) {
        GL gl = target.getGL();
        gl.glClear(16640);
        this._camera.apply(gl);
        this._arena.draw(gl);
    }

    public synchronized void update(float delta) {
        this._arena.update(delta);
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    public void init(GLAutoDrawable arg0) {
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        if (this._glu == null) {
            this._glu = new GLU();
        }
        GL gl = drawable.getGL();
        this.initGL(gl);
        this._width = width;
        this._height = height;
        gl.glViewport(x, y, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this._glu.gluPerspective(60.0, (float)width / (float)height, 0.1f, 100.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
        this._camera.trackballRelease();
        this._mouseValid = false;
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
        if ((arg0.getModifiersEx() & 0x1000) > 0) {
            if (this._mouseValid) {
                double r = this._camera.getRadius();
                this._camera.setRadius(r += ((double)arg0.getY() - this._lastMouseY) / 100.0);
            }
        } else if ((arg0.getModifiersEx() & 0x400) > 0) {
            this._camera.trackballMouse(arg0.getX(), arg0.getY(), this._width, this._height);
        }
        this._lastMouseY = arg0.getY();
        this._mouseValid = true;
    }
}

