/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.cs100r.robotArena;

import edu.cornell.cs.cs100r.robotArena.MainEventHandler;
import edu.cornell.cs.cs100r.robotArena.UpdateThread;
import edu.cornell.cs.cs100r.robotArena.arena.SimpleArena;
import edu.cornell.cs.cs100r.robotArena.robot.Robot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.opengl.GLCanvas;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.vecmath.Vector3d;

public class EnterTheArena {
    private static final long serialVersionUID = 1L;
    private GLCanvas canvas1;
    private SimpleArena myArena;
    private JButton runStopButton;
    private JButton addArenaObjectButton;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JLabel label_status;
    private final String STATUS_IDLE = "Welcome to the CS 100R Arena.";
    private final String STATUS_BAD_PLACE = "Sorry, that failed. \nPlease try different values.";
    private final String STATUS_GOOD_PLACE = "Congratulations, succesful robot placement.";
    private final String STATUS_ROOMBAS_ONLY = "Sorry, only adding Roombas is currently supported.";
    private final String ROBOTS_PONG = "Pong Robots, Go!";
    private final String ROBOTS_FREEZE = "Stop Robots!";
    private final String LIST_ROOMBA = "Roomba";
    private final String LIST_BOX = "Box";
    private final String LIST_TAPE = "Tape";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new EnterTheArena().createAndShowGUI();
            }
        });
    }

    private void createAndShowGUI() {
        JFrame frame = this.initComponents();
        frame.pack();
        frame.setVisible(true);
    }

    private JFrame initComponents() {
        JFrame frame = new JFrame("CS 100R Robot Arena");
        frame.setDefaultCloseOperation(3);
        JPanel all = new JPanel(new BorderLayout());
        all.setPreferredSize(new Dimension(740, 740));
        this.runStopButton = new JButton("Pong Robots, Go!");
        this.addArenaObjectButton = new JButton("Add New Arena Object");
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.canvas1 = new GLCanvas();
        this.canvas1.setAutoSwapBufferMode(false);
        this.myArena = new SimpleArena();
        MainEventHandler mainEventHandler = new MainEventHandler(this.myArena, this.canvas1);
        UpdateThread updater = new UpdateThread(mainEventHandler);
        updater.start();
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Roomba", "Box", "Tape"};
            private static final long serialVersionUID = 2L;

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jTextField1.setText("blank 1");
        this.jTextField2.setText("blank 2");
        this.jTextField3.setText("blank 3");
        this.label_status = new JLabel("Welcome to the CS 100R Arena.");
        this.label_status.setFont(new Font("Arial", 1, 20));
        this.runStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnterTheArena.this.label_status.setText("Welcome to the CS 100R Arena.");
                if (EnterTheArena.this.runStopButton.getText().equals("Pong Robots, Go!")) {
                    EnterTheArena.this.myArena.setPong(true);
                    int i = 0;
                    while (i < EnterTheArena.this.myArena.getNumRobots()) {
                        EnterTheArena.this.myArena.getRobotAt(i).unfreeze();
                        ++i;
                    }
                    EnterTheArena.this.runStopButton.setText("Stop Robots!");
                } else if (EnterTheArena.this.runStopButton.getText().equals("Stop Robots!")) {
                    EnterTheArena.this.myArena.setPong(false);
                    int i = 0;
                    while (i < EnterTheArena.this.myArena.getNumRobots()) {
                        EnterTheArena.this.myArena.getRobotAt(i).freeze();
                        ++i;
                    }
                    EnterTheArena.this.runStopButton.setText("Pong Robots, Go!");
                }
            }
        });
        this.addArenaObjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!EnterTheArena.this.jList1.getSelectedValue().equals("Roomba")) {
                        EnterTheArena.this.label_status.setText("Sorry, only adding Roombas is currently supported.");
                        return;
                    }
                    double theX = Double.parseDouble(EnterTheArena.this.jTextField1.getText());
                    double theY = Double.parseDouble(EnterTheArena.this.jTextField2.getText());
                    double theR = Double.parseDouble(EnterTheArena.this.jTextField3.getText());
                    if (theX < 0.05 || theX > 0.95 || theY < 0.05 || theY > 0.95) {
                        throw new NumberFormatException();
                    }
                    if (EnterTheArena.this.myArena.add(new Robot(EnterTheArena.this.myArena, new Vector3d(theX, 0.0, theY), theR, 0.0, 0.0, true))) {
                        EnterTheArena.this.label_status.setText("Congratulations, succesful robot placement.");
                    } else {
                        EnterTheArena.this.label_status.setText("Sorry, that failed. \nPlease try different values.");
                    }
                }
                catch (NumberFormatException ne) {
                    EnterTheArena.this.label_status.setText("Sorry, that failed. \nPlease try different values.");
                }
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                if (new String("Roomba").equals(EnterTheArena.this.jList1.getSelectedValue())) {
                    EnterTheArena.this.label_status.setText("Please Specifiy the coordinates of the center of the Roomba.");
                    EnterTheArena.this.jTextField1.setText("x in [0.1,0.9]");
                    EnterTheArena.this.jTextField2.setText("y in [0.1,0.9]");
                    EnterTheArena.this.jTextField3.setText("rotation");
                } else if (new String("Box").equals(EnterTheArena.this.jList1.getSelectedValue())) {
                    EnterTheArena.this.label_status.setText("Please Specifiy the coordinates of the top left and \nbottom right corners of the box.");
                    EnterTheArena.this.jTextField1.setText("x1 (1 space) x2");
                    EnterTheArena.this.jTextField2.setText("y1 (1 space) y2");
                    EnterTheArena.this.jTextField3.setText("rotation");
                } else if (new String("Tape").equals(EnterTheArena.this.jList1.getSelectedValue())) {
                    EnterTheArena.this.label_status.setText("Please Specifiy the coordinates of the top left and \nbottom right corners of the tape.");
                    EnterTheArena.this.jTextField1.setText("x1 (1 space) x2");
                    EnterTheArena.this.jTextField2.setText("y1 (1 space) y2");
                    EnterTheArena.this.jTextField3.setText("rotation");
                } else {
                    throw new RuntimeException("Invalid Arena Object.");
                }
            }
        });
        frame.setLayout(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        top.setPreferredSize(new Dimension(700, 500));
        this.canvas1.setPreferredSize(new Dimension(500, 500));
        top.add((Component)this.canvas1, "West");
        JPanel topRight = new JPanel(new BorderLayout());
        topRight.setPreferredSize(new Dimension(200, 500));
        this.runStopButton.setPreferredSize(new Dimension(100, 50));
        topRight.add((Component)this.runStopButton, "North");
        this.addArenaObjectButton.setPreferredSize(new Dimension(100, 50));
        topRight.add((Component)this.addArenaObjectButton, "Center");
        JPanel topRightBottomLeft = new JPanel(new BorderLayout());
        topRightBottomLeft.setPreferredSize(new Dimension(90, 400));
        this.jScrollPane1.setPreferredSize(new Dimension(90, 400));
        topRightBottomLeft.add(this.jScrollPane1);
        JPanel topRightBottom = new JPanel(new BorderLayout());
        topRightBottom.setPreferredSize(new Dimension(180, 400));
        topRightBottom.add((Component)topRightBottomLeft, "West");
        JPanel topRightBottomRight = new JPanel(new GridLayout(3, 1));
        topRightBottomRight.setPreferredSize(new Dimension(90, 400));
        this.jTextField1.setPreferredSize(new Dimension(90, 30));
        this.jTextField2.setPreferredSize(new Dimension(90, 30));
        this.jTextField3.setPreferredSize(new Dimension(90, 30));
        topRightBottomRight.add(this.jTextField1);
        topRightBottomRight.add(this.jTextField2);
        topRightBottomRight.add(this.jTextField3);
        topRightBottom.add((Component)topRightBottomRight, "East");
        topRight.add((Component)topRightBottom, "South");
        topRight.setBorder(new EmptyBorder(0, 20, 0, 0));
        top.add((Component)topRight, "East");
        all.add((Component)top, "North");
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setPreferredSize(new Dimension(700, 200));
        this.label_status.setPreferredSize(new Dimension(400, 100));
        bottom.add((Component)this.label_status, "Center");
        all.add((Component)bottom, "South");
        all.setBorder(new EmptyBorder(20, 20, 20, 20));
        frame.add(all);
        frame.setResizable(false);
        return frame;
    }

    public void clickRunStopButton() {
        this.runStopButton.doClick();
    }
}

