function varargout = part5_gui(varargin)
% part5_gui M-file for part5_gui.fig
%      part5_gui, by itself, creates a new part5_gui or raises the existing
%      singleton*.
%
%      H = part5_gui returns the handle to a new part5_gui or the handle to
%      the existing singleton*.
%
%      part5_gui('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in part5_gui.M with the given input arguments.
%
%      part5_gui('Property','Value',...) creates a new part5_gui or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before part5_gui_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to part5_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help part5_gui

% Last Modified by GUIDE v2.5 20-Jun-2006 16:29:33

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @part5_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @part5_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

function util_clear_ticks() 


function util_refresh_input(handles)
    if ~isempty(handles.template_image)
        imagesc(handles.template_image, 'Parent', handles.img_in);
    else
        imagesc(handles.input_image, 'Parent', handles.img_in);
    end

    set(handles.img_in, 'Visible', 'off');
    guidata(handles.img_in, handles);

function util_refresh_output(handles)
    oi = zeros(size(handles.input_image));
    for i=1:3
        oi(:,:,i) = handles.input_image(:,:,i); % .* uint8(handles.output_image);
    end
    oi = uint8(oi);

    imagesc(oi, 'Parent', handles.img_out);
    set(handles.img_out, 'Visible', 'off');
    guidata(handles.figure1, handles);

function [out] = util_colorize_bw(input)
    [rows,cols] = size(input);
    out = uint8(zeros(rows, cols, 3));
    out(:,:,1) = 255 * input;

function util_run_algorithm(handles)
%     handles.output_image = logical(threshold(handles.input_image, ...
%                                              get(handles.thresh_r, 'Value'), ...
%                                              get(handles.thresh_g, 'Value'), ...
%                                              get(handles.thresh_b, 'Value')));    
    if ~isempty(handles.template_image)
        util_refresh_output(handles);

        [detected, T] = detect_object(rgb2gray(handles.template_image), ...
            rgb2gray(im2double(handles.output_image)));
        
        if detected
           hold(handles.img_out, 'on');
           draw_transformed_object(handles.img_out, ...
                handles.template_image, T);
        end
            
        pause(0.05);
    end    

    hold(handles.img_out, 'off');

function util_dump_vbuffer(vid)
    getdata(vid, vid.FramesAvailable);

function util_start_recording(handles)
    handles.vid = videoinput('winvideo');
    handles.vid.TriggerFcn = @video_callback;
    handles.vid.TriggerRepeat = Inf;
    handles.vid.FramesPerTrigger = 1;
    handles.vid.UserData = handles.figure1;
    triggerconfig(handles.vid, 'Immediate');

    set(handles.figure1, 'UserData', handles.vid);
    guidata(handles.figure1, handles);
    start(handles.vid);

function util_stop_recording(handles)
    if (ishandle(handles.figure1))
        stop(get(handles.figure1, 'UserData'));
    end

function video_callback(obj, event)
    handles = guidata(obj.UserData);
    if(obj.FramesAvailable > 0)
        handles.input_image = getdata(obj, 1);
        handles.output_image = getdata(obj, 1);
        util_refresh_input(handles);

        % get the (possibly) newly saved handles structure back
        handles = guidata(obj.UserData);
        util_run_algorithm(handles);
        % util_refresh_output(handles);
        util_dump_vbuffer(obj);
    end

% --- Executes just before part5_gui is made visible.
function part5_gui_OpeningFcn(hObject, eventdata, handles, varargin)
    % This function has no output args, see OutputFcn.
    % hObject    handle to figure
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    % varargin   command line arguments to part5_gui (see VARARGIN)

%    imaqreset();

    % Choose default command line output for part5_gui
    handles.output = hObject;

    handles.input_image = [];
    handles.output_image = [];
    handles.recording = 0;
    handles.template_image = [];
    handles.template_frame = [];
    handles.template_desc = [];
    
    % Update handles structure
    guidata(hObject, handles);

    % UIWAIT makes part5_gui wait for user response (see UIRESUME)
    % uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = part5_gui_OutputFcn(hObject, eventdata, handles) 
    % varargout  cell array for returning output args (see VARARGOUT);
    % hObject    handle to figure
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Get default command line output from handles structure
    varargout{1} = handles.output;


% --- Executes on slider movement.
function thresh_r_Callback(hObject, eventdata, handles)
    % hObject    handle to thresh_r (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Hints: get(hObject,'Value') returns position of slider
    %        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
    set(handles.dthresh_r, 'String', num2str(round(get(hObject, 'Value'))));
    util_run_algorithm(handles);


% --- Executes during object creation, after setting all properties.
function thresh_r_CreateFcn(hObject, eventdata, handles)
    % hObject    handle to thresh_r (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    empty - handles not created until after all CreateFcns called

    % Hint: slider controls usually have a light gray background.
    if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor',[.9 .9 .9]);
    end

% --- Executes on slider movement.
function thresh_g_Callback(hObject, eventdata, handles)
    % hObject    handle to thresh_g (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Hints: get(hObject,'Value') returns position of slider
    %        get(hObject,'Min') and get(hObject,'Max') to determine range of
    %        slider
    set(handles.dthresh_g, 'String', num2str(round(get(hObject, 'Value'))));
    util_run_algorithm(handles);


% --- Executes during object creation, after setting all properties.
function thresh_g_CreateFcn(hObject, eventdata, handles)
    % hObject    handle to thresh_g (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    empty - handles not created until after all CreateFcns called

    % Hint: slider controls usually have a light gray background.
    if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor',[.9 .9 .9]);
    end


% --- Executes on slider movement.
function thresh_b_Callback(hObject, eventdata, handles)
    % hObject    handle to thresh_b (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Hints: get(hObject,'Value') returns position of slider
    %        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
    set(handles.dthresh_b, 'String', num2str(round(get(hObject, 'Value'))));
    util_run_algorithm(handles);

% --- Executes during object creation, after setting all properties.
function thresh_b_CreateFcn(hObject, eventdata, handles)
    % hObject    handle to thresh_b (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    empty - handles not created until after all CreateFcns called

    % Hint: slider controls usually have a light gray background.
    if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor',[.9 .9 .9]);
    end


% --------------------------------------------------------------------
function menu_File_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_File (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function menu_Image_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_Image (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function menu_Im_File_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_Im_File (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    [file, path] = uigetfile({ '*.bmp;*.jpeg;*.pgm;*.gif;*.png', 'Image Files' }, 'Load Image');
    if(file)
        handles.input_image = imread([path '/' file]);
        util_refresh_input(handles);
    end


% --------------------------------------------------------------------
function menu_Im_Camera_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_Im_Camera (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    xv = videoinput('winvideo');
    start(xv);
    handles.input_image = getdata(xv, 1);
    stop(xv);
    util_refresh_input(handles);


% --------------------------------------------------------------------
function menu_Im_Ceiling_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_Im_Ceiling (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    handles.input_image = getCeiling();
    util_refresh_input(handles);

% --------------------------------------------------------------------
function menu_Im_SaveInput_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_Im_SaveInput (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    [ file, path ] = uiputfile('*.bmp', 'Save Image');
    if(file)
        imwrite(handles.input_image, [path '/' file], 'bmp');
    end


% --------------------------------------------------------------------
function menu_Im_SaveOutput_Callback(hObject, eventdata, handles)
    % hObject    handle to menu_Im_SaveOutput (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    [ file, path ] = uiputfile('*.bmp', 'Save Image');
    if(file)
        imwrite(handles.output_image, [path '/' file], 'bmp');
    end


% --- Executes on selection change in pop_version.
function pop_version_Callback(hObject, eventdata, handles)
    % hObject    handle to pop_version (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Hints: contents = get(hObject,'String') returns pop_version contents as cell array
    %        contents{get(hObject,'Value')} returns selected item from pop_version


% --- Executes during object creation, after setting all properties.
function pop_version_CreateFcn(hObject, eventdata, handles)
    % hObject    handle to pop_version (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    empty - handles not created until after all CreateFcns called

    % Hint: popupmenu controls usually have a white background on Windows.
    %       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end

% --- Executes on selection change in pop_algo.
function pop_algo_Callback(hObject, eventdata, handles)
    % hObject    handle to pop_algo (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Hints: contents = get(hObject,'String') returns pop_algo contents as cell array
    %        contents{get(hObject,'Value')} returns selected item from pop_algo

% --- Executes during object creation, after setting all properties.
function pop_algo_CreateFcn(hObject, eventdata, handles)
    % hObject    handle to pop_algo (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    empty - handles not created until after all CreateFcns called

    % Hint: popupmenu controls usually have a white background on Windows.
    %       See ISPC and COMPUTER.
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end

% --- Executes on button press in capture_template.
function capture_template_Callback(hObject, eventdata, handles)
    % hObject    handle to camera_button (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    if(handles.recording)
        handles.template_image = im2double(handles.input_image);
        % guidata(handles.template_image, handles);
        % guidata(handles.template_frame, handles);
        % guidata(handles.template_desc, handles);
    end

    guidata(hObject, handles);
    
% --- Executes on button press in camera_button.
function camera_button_Callback(hObject, eventdata, handles)
    % hObject    handle to camera_button (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    if(handles.recording)
       handles.recording = 0;
       set(hObject, 'String', 'Start Camera');
       refresh();
       util_stop_recording(handles);
       % set(handles.rralgorithm_button, 'Enable', 'on');
    else
       handles.recording = 1;
       % set(handles.rralgorithm_button, 'Enable', 'off');
       set(hObject, 'Enable', 'off');
       refresh();
       util_start_recording(handles);
       set(hObject, 'String', 'Stop Camera');
       set(hObject, 'Enable', 'on');
    end
    guidata(handles.figure1, handles);

% --- Executes on button press in rralgorithm_button.
function rralgorithm_button_Callback(hObject, eventdata, handles)
    % hObject    handle to rralgorithm_button (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    util_run_algorithm(handles);

% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
    % hObject    handle to figure1 (see GCBO)
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)

    % Hint: delete(hObject) closes the figure
    delete(hObject);
    util_stop_recording(handles);

