function [ image ] = robotGetFrame( robot )
    frame = robot.iface.invoke('getFrame', []);
    
    % Pull values out of the struct.
    width = frame.getInteger('width');
    height = frame.getInteger('height');
    channels = frame.getInteger('channels');
    depth = frame.getInteger('depth');
    image = frame.getBinary('image');
    
    % First, the image bytes are encoded in two's complement, but Java
    % doesn't even support unsigned bytes, so we have to add 256 to all
    % negative values.
    image = uint8(int16(image) + int16(image < 0) * 256);
    
    % Now, we need to do some weird reshaping and dimension permuting to
    % get the image into the right format for Matlab.
    image = reshape(image, channels, width * height);
    image = shiftdim(image, 1);
    image = reshape(image, width, height, channels);
    image = permute(image, [2 1 3]);
    
    % Finally, we need to switch the channels around if there are three of
    % them
    if (channels == 3)
        image(:,:,[1, 3]) = image(:,:,[3, 1]);
    end
    