function urbiSendWav(con, wavFile, variableName)
% Write the sound from a wav file to a variable on the server
% This function send the wav file to a variable on the URBI server.
% Default variable is 'speaker.val', thus playing the sound on the 
% robot speaker.

if (nargin<2)
    error(['urbiSendWav(con, wavFile, variableName)\n' ...
           '  con : ID of the connection to the Urbi server\n' ...
           '  waveFile : wav file to be sent\n' ...
           '  variableName : Urbi variable in which the sound will be ' ...
           'sent (default : speaker.val)'],1);
end

if (nargin==2)
    variableName='speaker.val';
end

fid = fopen(wavFile,'r');
if fid==-1
    error (sprintf('Unable to open %s', wavFile));
end;

bin_datas = fread(fid);
bin_datas = char(bin_datas');
fclose(fid);
urbiSend(con, sprintf ('%s = BIN %d wav;', variableName, size(bin_datas, 2)));
pnet(con.id, 'write', bin_datas, 'char');
