function urbiSendSound(con, sound,variableName) 
% Write a sound to a variable on the Urbi server
% This function send the content of a sound struct to a variable on the Urbi
% server. Default variable is 'speaker.val', thus playing the sound on the 
% robot speaker.


if (nargin<2)
    error(['urbiSendSound(con, sound,variableName)\n' ...
           '  con : ID of the connection to the Urbi server\n' ...
           '  sound : sound struct to be sent\n' ...
           '  variableName : Urbi variable in which the sound will be sent (default : speaker.val)'],1);
end

if (nargin==2)
    variableName='speaker.val';
end

urbiSend(con, sprintf ('%s = BIN %d raw %d %d %d %d;',variableName, sound.length, sound.channel, sound.Fs, sound.nbits, 1))

pnet(con.id, 'write', sound.samples, 'char');
