function urbiSend(con, command)
% Send an Urbi command string to the server
% This function sends a string to the Urbi server. No process is made of
% the server responses. If you want a display of the messages from the
% server, use urbiInteract. If you want to process the messages, use urbiGet.
% e.g. urbiSend(con, 'whenever (camera.visible == 1) { echo("ball!");};');


if (nargin~=2)
    error(['urbiSend(con, command)\n' ...
           '  con : ID of the connection to the Urbi server\n' ...
           '  command : command string to be sent to URBI'],1);
end

pnet(con.id, 'printf', '%s', command);

