function urbiInteract(con, command)
% Send an URBI command string and display messages from the server
% This functions performs the same job as urbiSend, but displays the
% messages returned by the server. It should be used mostly in an
% interactive manner, and not in scripts, as messages are lost for
% processing
% e.g. urbiInteract(con, 'headPan.val');

if (nargin~=2)
    error(['urbiInteract(con, command)\n' ...
           '  con : ID of the connection to the Urbi server\n' ...
           '  command : command string to be sent to URBI'],1);
end


urbiSend(con, command);
pause(.1);
urbiClearConnection(con);
