function [data,timeStamp,type] = urbiGetVariable(con, device)
% Read a variable value from the Urbi server
% e.g. v = urbiGetVariable(con, 'headPan.val');
% The data are the same as in a umessage given by urbiGet, but in a 
% different order to suit matlab conventions about missing output arguments
% and facilitate return value exploitation
%
%  timeStamp  : the time stamp of the message
%  type       : the type of the message: 'numeric', 'string',
%               'list', 'system', 'object', 'image', 'sound',
%               or 'otherBIN'
%  data      : variable value
%                numeric         if type == numeric
%                character array if type == string
%                cell array      if type == list
%                character array if type == system
%                character array if type == object
%                character array if type == image
%                struct          if type == sound
%                                (with fields samples, Fs, nbits, length)
%                bytes array     if type == otherBIN

if (nargin <2)
    error(['urbiGetDevice(con, device)\n' ...
           '  con : ID of the connection to the Urbi server\n' ...
           '  device : name of the variable to read'],1);
end

urbiClearConnection(con,1);
tag_base = 'gdftag';
% Uses tag to choose the right answer among results
% Note requested results outputed before are lost

urbiSend(con, [tag_base ' ' con.tagOperator ' ' device ';']);

answer=struct('tag','');
while ~strcmp (answer.tag, tag_base)
    answer=urbiGet(con);
end;

type = answer.type;
data = answer.value;
timeStamp = answer.timeStamp;

