function [matrix, timeStamp] = urbiGetImage(con,deviceName)
% Get the current image from the Urbi server  (default device : camera.val)
% This function gets the image from the specified device, or from the
% device "camera.val" if it is not specified
% The parameters for the camera must be set by the user with urbiSend
%
% This function returns :
%   matrix = matrix of the image (display with imshow(matrix);)
%   timeStamp = time at which the image was taken by the robot

if (nargin <1)
    error(['urbiGetImage(con,deviceName)\n' ...
           '  con : Id of the Urbi server connection\n' ...
           '  deviceName : name of the image to get (default : camera.val)'],1);
end

if (nargin == 1)
  deviceName='camera.val';
end

urbiSend(con,'camera.reconstruct = 1;\ncamera.jpegfactor = 0;');

[matrix,timeStamp] = urbiGetVariable(con,deviceName);