function umessage = urbiGet(con)
% Read the next message coming from the server
% Output the next message coming from the Urbi server 
% in a 'umessage' structure with fields:
%
%  umessage.timeStamp  : the time stamp of the message
%  umessage.tag        : the tag of the message
%  umessage.type       : the type of the message: 'numeric', 'string',
%                        'list', 'system', 'object', 'image', 'sound',
%                         or 'otherBIN'
%  umessage.value      : message content:
%                           numeric         if type == numeric
%                           character array if type == string
%                           cell array      if type == list
%                           character array if type == system
%                           character array if type == object
%                           character array if type == image
%                           struct          if type == sound
%                                (with fields samples, Fs, nbits, length)
%                           bytes array     if type == otherBIN


if (nargin <1)
    error('urbiGet(con)\n con : ID of the connection to close',1);
end

string = pnet(con.id, 'readline', 'view', 'noblock');

if (~isempty(string))
    umessage = urbiFullParse(string, con);
else
    umessage = struct('timeStamp', 0, 'tag', '', 'type', 'empty', 'value', 0);
end

end
