function urbiSound2Wav (sound,wavFile)
% Convert a sound structure to a wav file

if (nargin <2)
    error(['urbiSound2Wav (sound,wavFile)\n' ...
           '  sound : sound struct to be saved\n' ...
           '  wavFile : name of the target wav file'],1);
end

fid = fopen(wavFile,'wb');
if fid==-1
    error (sprintf('Unable to open %s', wavFile));
end;

full_size = sound.length;
size_char = 1;
size_short = 2;
size_int = 4;

size_of_wav_header = 4 + size_int + 4 + 4 + size_int + size_short + ...
    size_short +size_int + size_int + size_short + size_short + 4 + size_int;

H = ['RIFF'];
H = [H urbiInt2Chars(50 + full_size/sound.channel, size_int)];
H = [H 'WAVE' 'fmt '];
H = [H urbiInt2Chars(16, size_int)];
H = [H urbiInt2Chars(1, size_short)];
H = [H urbiInt2Chars(sound.channel, size_short)];
H = [H urbiInt2Chars(sound.Fs, size_int)];
H = [H urbiInt2Chars(floor(sound.Fs * sound.channel * (sound.nbits / 8)), size_int)];
H = [H urbiInt2Chars((sound.nbits/8) * sound.channel, size_short)];
H = [H urbiInt2Chars(sound.nbits, size_short)];
H = [H 'data'];
H = [H urbiInt2Chars(full_size, size_int)];

fwrite(fid, H , 'uchar');

fwrite(fid,sound.samples,'uchar');
fclose(fid);