function s=urbiInt2Chars(i, length)
% Convert a value to corresponding binary string in length byte
%  This function is used in converting a sound to a Wav file.

base = 2^((length - 1)* 8);
s = floor(i / base);
i = mod (i, base);
for n = length-1:-1:1
    base = base / 256;
    s = [floor(i / base) s];
    i = mod (i, base);    
end;
s=char(s);