function urbiClearConnection(con,silence) 
% Flush the connection coming from the server
% This function clears all the data coming from the server contained in 
% the input buffer in order to get a clean entry for the next messages. 
% This is useful if something went wrong with binary data input for
% example.
%
% The function outputs the result to screen if there is only one argument 

if (nargin <1)
    error(['urbiClearConnection(con,silence)\n' ...
           '  con : connection to urbi server\n' ...
           '  silence : output to screen if absent'],1);
end

% Clear lines by lines
r = pnet(con.id, 'readline', 'noblock');
while ~isempty(r)
    r = pnet(con.id, 'readline', 'noblock');
end;

% Finish the work char by char
r = pnet(con.id, 'read',1,'char', 'noblock');
R = [];
while ~isempty(r)
    if (nargin == 1)
     R = [R r];
    end
r = pnet(con.id, 'read',1,'char', 'noblock');
end;
