classdef Room < handle
    % A room at a fixed location within a cave.

    properties (Access=private)
        pos  % Position ([x,y]) of tile on game board

        % Graphics properties
        tile  % Graphics object for room tile
    end

    methods

        function obj = Room(pos)
            % Construct a Room at game board position `pos` ([x,y]).

            obj.pos = pos;

            % Set up graphics
            obj.tile = fill([pos(1), pos(1)+1, pos(1)+1, pos(1)], ...
                            [pos(2), pos(2), pos(2)+1, pos(2)+1], ...
                            [0.8, 0.7, 0]);
        end

        function pos = getPos(self)
            % Return position ([x,y]) of this Room on the game board.
            pos = self.pos;
        end

        function visit(self, player)
            % Respond to a Player `player` moving into this Room.

            % Base class does nothing
        end

        function setColor(self, color)
            % Set color of tile used to draw this room to `color`.
            self.tile.FaceColor = color;
        end

        function addText(self, txt)
            % Show a string of text `txt` on top of this room's tile.
            text(self.pos(1)+0.1, self.pos(2)+0.8, txt);
        end

    end

end
