classdef Player < Character
    % Player character in cave game.  Movement controlled by user.

    properties (Access=private)
        health  % Health points of player
        poisoned  % Whether or not player is poisoned

        % Configurable parameters
        cureProb = 0.25  % Probability of curing poisoned status each move
        poisonDamage = 10  % Amount of damage caused by poison each move
    end

    methods

        function obj = Player(start, map)
            % Construct a player in Room `start` within Map `map`.

            % TODO: Implement constructor so that:
            % 1. Player is shown with a blue marker labeled "P"
            % 2. Player initially has 100 health points
            % 3. Player is not initialaly poisoned
        end

        function h = getHealth(self)
            % Return number of health points this Player currently has.
            h = self.health;
        end

        function p = isPoisoned(self)
            % Return true if this Player is currently poisoned.

            % TODO: Implement
        end

        function damage(self, d)
            % Reduce this player's health points by ammount `d`.

            % TODO: Implement
        end

        function poison(self)
            % Poison this player.
            self.poisoned = true;
        end

        % TODO: Override `startTurn()` so that Players get 2 moves per turn.


        % TODO: Override `move()` so that Players visit the room they move to.


        function dir = nextDir(self)
            % Return the next direction [dx, dy] that the Player should
            % move in.  Movement will be to the adjacent room (diagonals
            % included) in direction that user clicks in, bounded by map
            % size.

            % Ask user to click on figure, then determine corresponding
            % room position by rounding down.
            t = floor(ginput(1));
            % Clamp room position to within map boundary.
            t = min(t, self.map.getDims());
            t = max(t, [1, 1]);

            % Compute direction to target position, then constrain to
            % adjacent rooms (`sign()` clamps displacement to {-1, 0, 1}).
            dir = sign(t - self.getPos());
        end

        function update(self)
            % Update Player state to account for poison.

            % TODO: Implement the following poison logic:
            % 1. Cure poison status with probability `cureProb`
            % 2. If poisoned, reduce health by `poisonDamage`
        end

    end

end
