classdef Map < handle
    % A game board representing a "cave", made up of a retangular grid of
    % rooms.

    properties (Access=private)
        % 2D cell array containing rooms (rooms{x,y} has position [x,y])
        % (the map is not drawn in "matrix order" - the first index
        % corresponds to HORIZONTAL position)
        rooms = {}
    end

    methods
        function addRoom(self, room)
            % Add `room` to this map.
            % Components of room's position must be integers >= 1.
            p = room.getPos();
            self.rooms{p(1), p(2)} = room;
        end

        function r = getRoom(self, pos)
            % Get room at position `pos`.
            r = self.rooms{pos(1), pos(2)};
        end

        function dims = getDims(self)
            % Return dimensions ([ncols,nrows]) of map.
            % See property documentation for clarification of ordering.
            dims = size(self.rooms);
        end

        function x = getExitPos(self)
            % Return position ([x,y]) of exit room.
            x = self.getDims();  % Exit is always top-right corner
        end
    end
end
