classdef Room < handle
    % A room has an id, rooms to the north, east, south, and west, and an
    % exit property.
    
    properties(Access = private)
        id   % Unique id
    end %private properties
    
    properties
        xCoord
        yCoord
        exit
        playerInRoom
        monsterInRoom
        hazardID
        playerVisited
    end %public properties
    
    properties (Constant)
        hazardAmount= 20;  % Standard deduction of player's health if 
                           % player enters a trap room.
    end

    methods
        function r = Room(xCoord, yCoord, exit, id, pIn, mIn, hID)
        % Set fields to arguments if only all 7 arguments are given
            % TODO
            r.xCoord = 0;
            r.yCoord = 0;
            r.exit = 0;
            r.id = 0;
            r.playerInRoom = 0;
            r.monsterInRoom = 0;
            r.hazardID = 0;
            r.playerVisited = 0;
        end
        
        function [xCoord, yCoord] = getLoc(self)
            % TODO
            xCoord = 0;
            yCoord = 0;
        end
        
        function id = getID(self)
            % TODO
            id = 0;
        end
        
        function bool = isHazardous(self)
            % TODO
            bool = 0;
        end
        
        function applyHazard(self, player)
            % TODO
        end
        
        % ---- Do not modify the code below ---- %
        function draw(self)
            if self.xCoord == 1 && self.yCoord == 1
                str = sprintf('Room %d\nStart!',self.id);
            else
                str = sprintf('Room %d',self.id);
            end
            if self.exit == 1
                col = [0.9,0.9,0.2];
                str = sprintf('Room %d\nExit here!',self.id);
            elseif self.playerVisited && self.hazardID==1
                col= ([174, 18, 0])/256;
            elseif self.playerVisited && self.hazardID==2
                col= ([72, 245, 7])/256;
            else
                col = [0.9,0.7,0.4];
            end
            DrawRect(self.xCoord,self.yCoord,1,1,col)
            text(self.xCoord+0.1,self.yCoord+0.8,str)
        end
        
    end % public methods
    
end % class Room