function [colr, gray] = pointillize(A,n,t,ani)
%"Pointillize" an image.
% A:  3-d uint8 array of color image data
% n:  Block size, i.e., each block contains n*n pixels (n rows by n cols)
% t:  Grayness threshold below which a block will be presented in color; at
%     or above t a block will be presented in gray.  0<=t<=1.
% ani:  a 0-1 scalar.  1=animate drawing; 0=draw still graphic.
% Crop array A such that its number of rows and number of columns of pixels
% are each a multiple of n.
% Type double arrays colr and gray store RGB and gray intensities, each in
% the range of 0 to 1.
% gray is an nrb-by-ncb array of type double values storing the average 
% gray intensity of each block of pixels, where nrb and ncb are the 
% number of blocks in the row and column dimensions, respectively.
% colr is an nrb-by-ncb-by-3 array of type double values:
%   colr(:,:,1) store the average red intensity of each block
%   colr(:,:,2) store the average green intensity of each block
%   colr(:,:,3) store the average blue intensity of each block
% The program should halt execution with an appropriate error message if 
% the parameter values result in either of these cases:
%   - the number of blocks in either or both dimensions is <10
%   - ani is 1 and the number of blocks in either or both dimensions is >80

close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Write your code below %%%%



%%%% Write your code above %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Animate dots or make still figure
if ani
    animateDots(colr,gray,t)
else
    drawDots(colr,gray,t)
end
