/* Defines a vertex, i.e., a grid point.
   A Vertex has x and y coordinates, approximated using the column index and
   negative row index, respectively.  A Vertex is either an edge grid point 
   or an interior grid point. 
   */

public class Vertex{
  private double x; //x coordinate, based on pixel column index
  private double y; //y coordinate, based on NEGATIVE pixel row index 
  private boolean isEdge; // has the value 1 if an edge grid point; otherwise 0
  
  public Vertex(double pixRowInd, double pixColInd, boolean isEdge, double maxNoise){
    this.x = pixRowInd;
    this.y = pixColInd;
    this.isEdge = isEdge;
    if (!this.isEdge){
      this.perturb(maxNoise);
    }
  }
  
  private void perturb(double maxNoise){
    double rand = Math.random();
    this.x = this.x + rand*2*maxNoise - maxNoise;
    this.y = this.y + rand*2*maxNoise - maxNoise;
  }
  
  public double getX(){
    return this.x;
  }
  
  public double getY(){
    return this.y;
  }
}