import java.awt.*;

/* Defines a tile in a stained glass image.
   A Tile has a color represented as rgb values and a set of vertices, each
   is a Vertex.
   */

public class Tile{
  private double[] colr; // length 3 vector of doubles: rgb values, each in [0,1]
  private Vertex[] vertices; // length 4 cell array of Vertex references
  
  public Tile(double[] colr, Vertex[] vertices){
    this.colr = colr;
    this.vertices = vertices;
  }
  
  public void draw(Graphics g){
    int x[] = {0, 0, 0, 0, 0};
    int y[] = {0, 0, 0, 0, 0};
    int nPoints = 5;

    for (int i=0; i<4; i++){
      x[i] = (int)this.vertices[i].getX();
      y[i] = (int)this.vertices[i].getY();
    }
    x[4] = (int)this.vertices[0].getX();
    y[4] = (int)this.vertices[0].getY();

    g.setColor(new Color(0.0f, 0.0f, 0.0f));
    g.drawPolygon(x, y, nPoints);
    g.setColor(new Color((float)colr[0], (float)colr[1], (float)colr[2]));
    g.fillPolygon(x, y, nPoints);
  }
}