function randomWalkRobot5(serPort)
% Robot performs a random walk inside a room until it bumps into a wall.
% The robot's location during its forward travel is recorded every .2
% second.  The location data is written to a textfile with the file name  
% trip<hh><mm><ss>.txt  with <hh> replaced by the 2-digit hours string 
% (24-hour clock), <mm> replaced by the 2-digit minutes string, and <ss> 
% replaced by the 2-digit seconds string.
% serPort is the serial port number (for controlling the actual robot).
% Each step of the random walk is a random rotation followed by 1 second of
% moving forward.

% Parameter for random angle: w times as likely to advance as to retreat
w = 3;

% Random walk
[BumpRight,BumpLeft,WheDropRight,WheDropLeft,WheDropCaster,BumpFront] = ...
    BumpsWheelDropsSensorsRoomba(serPort);
while ~BumpRight && ~BumpLeft && ~BumpFront
    theta= getRandAngle(w);
    turnAngle(serPort, .2, theta)
    SetDriveWheelsCreate(serPort, .5,.5)
    pause(1)
    StopCreate(serPort)
    [BumpRight,BumpLeft,WheDropRight,WheDropLeft,WheDropCaster,BumpFront] = ...
        BumpsWheelDropsSensorsRoomba(serPort);
end
Signal()


%%%%%%%%%%%%%%%%%%%%%%%%
function d = getRandAngle(w)
% d is a random angle in degrees. d is w times as likely to be an advance
%   angle than a retreat angle.  w is a positive integer.
% d is an advance angle if -90<d<90; d is a retreat angle if 90<d<270.

nIntervals= w+1;
splitPoint= 1/nIntervals; 
if rand < splitPoint  % backward
    d= rand*180+90;
else                  % forward
    d= rand*180-90;
end


%%%%%%%%%%%%%%%%%%%%%%%%
function StopCreate(serPort)
% Stop the robot
% serPort is the serial port number (for controlling the actual robot).
SetDriveWheelsCreate(serPort, 0,0)


%%%%%%%%%%%%%%%%%%%%%%%%
function Signal()
% Make signal sound (4 beeps)
n= 4;
for k=1:4
    beep
    pause(.2)
end
    