function exploreRoom5(serPort)
% Robot explores a rectangular room and records its location once every 
% .2 second when it is not rotating.  The location data is written to 
% a textfile with the file name  trip<hh><mm><ss>.txt  with <hh> replaced
% by the 2-digit hours string (24-hour clock), <mm> replaced by the 2-digit 
% minutes string, and <ss> replaced by the 2-digit seconds string.
% serPort is the serial port number (for controlling the actual robot).
% Assume robot begins in SW corner and faces E.
% Solid walls on W, S ,E sides; N wall is a virtual wall.

nLegs= 0;  % number of legs (long straight traverse) so far
r= 0;      % number of bumper readings so far
virtualWallSignal = VirtualWallSensorCreate(serPort);

while ~virtualWallSignal
   
    % Keep wandering in some kind of s-path: 
    % long straight traverse then turn to face opposite dir after moving up

    [BumpRight,BumpLeft,WheDropRight,WheDropLeft,WheDropCaster,BumpFront] = ...
        BumpsWheelDropsSensorsRoomba(serPort);
    % Long straight traverse
    while ~BumpFront && ~virtualWallSignal
        SetDriveWheelsCreate(serPort, .5,.5)
        pause(.2)
        [BumpRight,BumpLeft,WheDropRight,WheDropLeft,WheDropCaster,BumpFront] = ...
            BumpsWheelDropsSensorsRoomba(serPort);
        r= r + 1;
    end
    nLegs= nLegs + 1;
    % Hit wall. So set up for next long straight travel in opposite dir:
    % back up, turn 90deg, travel up a little, turn 90deg
    SetDriveWheelsCreate(serPort, -.5,-.5)
    pause(.01)
    if rem(nLegs,2)==1  % Just finished traveling right, so turn ccw
        angle= 90;
    else                % Just finished traveling left, so turn cw
        angle= -90;
    end
    turnAngle(serPort, .2, angle)
    SetDriveWheelsCreate(serPort, .5,.5)
    pause(.4)
    turnAngle(serPort, .2, angle)
    virtualWallSignal = VirtualWallSensorCreate(serPort);

end
Signal()


%%%%%%%%%%%%%%%%%%%%%%%%
function StopCreate(serPort)
% Stop the robot
% serPort is the serial port number (for controlling the actual robot).
SetDriveWheelsCreate(serPort, 0,0)


%%%%%%%%%%%%%%%%%%%%%%%%
function Signal()
% Make signal sound (4 beeps)
n= 4;
for k=1:4
    beep
    pause(.2)
end
    