"""
View class/module for temperature converter

This is the VIEW for the temperature converter application.  The view must layout all
of the graphics components.

Note that the view does very little else.  Furthermore, it does not even have a method 
to start up the application.  That is the job of the controller.

Author: Walker M. White (wmw2)
Date:   October 20, 2020
"""


from kivy.uix.boxlayout import BoxLayout
from kivy.uix.textinput import TextInput
from kivy.uix.label import Label
from kivy.uix.widget import Widget
from kivy.metrics import dp

class TemperaturePanel(BoxLayout):
    """
    A class representing a Kivy input panel.

    This class is filled with Kivy specific code.  You are no expected to understand it.
    """
    # INSTANCE ATTRIBUTES
    # Attribute _fahrenheit: The text input field for fahrenheit
    # Invariant: _fahrenheit is a Kivy TextInput object
    #
    # Attribute _centigrade: The text input field for centigrade
    # Invariant: _centigrade is a Kivy TextInput object

    def getFahrenheitText(self):
        """
        Returns the contents of the fahrenheit text box
        """
        return self._fahrenheit.text

    def setFahrenheitText(self,value):
        """
        Sets the contents of the fahrenheit text box

        Parameter value: The new box contents
        Precondition: value is a string
        """
        assert type(value) == str, repr(value)+' is not a string'
        self._fahrenheit.text = value

    def linkFahrenheit(self,callback):
        """
        Links a callback function to the fahrenheit field

        Parameter callback: The callback function
        Precondition: callback a function that takes an text input and string as args
        """
        self._fahrenheit.bind(on_text_validate=callback)

    def getCentigradeText(self):
        """
        Returns the contents of the centigrade text box
        """
        return self._centigrade.text

    def setCentigradeText(self,value):
        """
        Sets the contents of the centigrade text box

        Parameter value: The new box contents
        Precondition: value is a string
        """
        assert type(value) == str, repr(value)+' is not a string'
        self._centigrade.text = value

    def linkCentigrade(self,callback):
        """
        Links a callback function to the centigrade field

        Parameter callback: The callback function
        Precondition: callback a function that takes an text input and string as args
        """
        self._centigrade.bind(on_text_validate=callback)


    def __init__(self,**kw):
        """
        Initializes a new TemperaturePanel

        Parameter kw: The keyword arguments
        Precondition: kw is  dictionary
        """
        # This code is horrendous. It is filled with magic numbers
        # This code is from 2011 back when Kivy was old
        # Do not write code like this.
        super(TemperaturePanel,self).__init__(**kw)
        self.orientation = 'vertical'

        # Vertical spacing
        widget = Widget(size_hint=(1,0.35))
        self.add_widget(widget)

        content = BoxLayout(orientation='horizontal',size_hint=(1,0.3))
        self.add_widget(content)

        widget = Widget(size_hint=(1,0.35))
        self.add_widget(widget)

        FONT_SIZE = 21*dp(1)

        # Horizontal Content
        # Space before
        widget = Widget(size_hint=(0.025,1))
        content.add_widget(widget)

        # Farenheit
        label = Label(text='farenheit',font_size=FONT_SIZE,bold=True)
        label.size_hint = (0.225,1)
        content.add_widget(label)

        text = TextInput(multiline=False,font_size=FONT_SIZE)
        text.halign='center'
        text.size_hint = (0.2,1)
        text.padding = [0,35,0,0]
        content.add_widget(text)
        self._fahrenheit = text

        # Space between
        widget = Widget(size_hint=(0.05,1))
        content.add_widget(widget)

        # Centigrade
        label = Label(text='centigrade',font_size=FONT_SIZE,bold=True)
        label.size_hint = (0.225,1)
        content.add_widget(label)

        text = TextInput(multiline=False,font_size=FONT_SIZE)
        text.halign='center'
        text.size_hint = (0.2,1)
        text.padding = [0,35,0,0]
        content.add_widget(text)
        self._centigrade = text

        # Space after
        widget = Widget(size_hint=(0.075,1))
        content.add_widget(widget)
