"""
A generator to show off harmonic partial sums.

This particular example should be put in the Python Tutor.  It shows what happens
when we put a generator in a for-loop.

Author: Walker M. White (wmw2)
Date: October 28, 2020
"""


def rnginv(n):
    """
    Generates the numbers 1, 1/2, 1/3, ..., 1/n
    
    Parameter n: The limit of the range
    Precondition: n is an int > 0
    """
    for x in range(1,n):
        yield 1/x


def harmonic(n):
    """
    Returns the nth partial sum for the harmonic series
    
    The result is 1+1/2+1/3+...+1/n
    
    Parameter n: The limit of the range
    Precondition: n is an int > 0
    """
    sum = 0
    g = rnginv(n)
    for x in g:
        sum = sum+x
    return x
      
