"""
A module for the merge sort algorithm

Author: Walker M. White (wmw2)
Date:   November 10, 2017 (Python 3 Version)
"""
import random



def sort(b):
    """
    Merge Sort: Sorts the array b in guaranteed n log n time

    Parameter b: The sequence to sort
    Precondition: b is a mutable sequence (e.g. a list).
    """
    assert type(b) == list, repr(b)+' is not a list'

    # Send everything to the recursive helper
    _msort_helper(b,0,len(b)-1)


def _msort_helper(b, h, k):
    """
    Quick Sort: Sorts the array b[h..k] in n log n average
    time

    Parameter b: The sequence to sort
    Precondition: b is a mutable sequence (e.g. a list).

    Parameter h: The starting point to sort
    Precondition: h is an int and a valid position in b

    Parameter k: The ending poing to sort
    Precondition: k is an int and a valid position in b
    """
    # We typically do not enforce preconditions on hidden helpers
    if k-h < 1:            # BASE CASE
        return


    # RECURSIVE CASE
    # Find the middle and sort two halves
    mid = (h+k)//2
    _msort_helper(b,h,mid)
    _msort_helper(b,mid+1,k)

    # Merge the two halves
    _merge(b, h, mid, k)


def _merge(b,h,m,k):
    """
    Procedure merges the halves b[h:m] and b[m+1:k] together into b[h:m]

    The function assumes b[h:m] and b[m+1:k] are sorted.  When merging
    the two together, the final result b[h:m] is sorted.

    Parameter b: The sequence to sort
    Precondition: b is a mutable sequence (e.g. a list).

    Parameter h: The starting point to sort
    Precondition: h is an int and a valid position in b

    Parameter m: The starting point to sort
    Precondition: m is an int and a valid position in b

    Parameter k: The ending poing to sort
    Precondition: k is an int and a valid position in b

    Additional Precondition: b[h:m], b[m+1:k]
    """
    # Make a COPY of the two halves (this is the expensive part)
    # REMEMBER, slicing is different from h..k; need one more
    left = b[h:m+1]
    rght = b[m+1:k+1]

    # Need a loop variable for EACH of the lists
    posl = 0
    posr = 0
    posb = h

    # Merge the copies left and right back into b
    while (posl < len(left) and posr < len(rght)):
        if left[posl] < rght[posr]:
            b[posb] = left[posl]
            posl = posl + 1
        else:
            b[posb] = rght[posr]
            posr = posr + 1
        posb = posb+1

    # If anything remaining, either left or rght not done
    if posb <= k:
        while posl < len(left):
            b[posb] = left[posl]
            posl = posl + 1
            posb = posb+1

        while posr < len(rght):
            b[posb] = rght[posr]
            posr = posr + 1
            posb = posb+1


def _swap(b, h, k):
    """
    Procedure swaps b[h] and b[k]

    Parameter b: The list to rearrange
    Precondition: b is a mutable sequence (e.g. a list).

    Parameter h: The first position to swap
    Precondition: h is an int and a valid position in b

    Parameter k: The second position to swap
    Precondition: k is an int and a valid position in b
    """
    # We typically do not enforce preconditions on hidden helpers
    temp = b[h]
    b[h] = b[k]
    b[k] = temp


def scramble(b):
    """
    Scrambles the list to resort again

    Parameter b: The list to scramble
    Precondition: b is a mutable sequence (e.g. a list).
    """
    assert type(b) == list, repr(b)+' is not a list'

    # Start from the beginning
    i = 0
    while i < len(b):
        size = len(b)-i
        pos  = int(random.random()*size)
        _swap(b,i,i+pos)
        i = i+1
