"""
Functions to show how type-specific try-except works

Author: Walker M. White (wmw2)
Date:   October 28, 2017 (Python 3 Version)
"""


def first(i):
    """
    Our first function, it passes the argument i to second().
    
    It contains the try-except block for AssertionError.
    Throws: ValueError        i == 4
    
    Parameter i: An int to control program flow
    Precondition: i is an int
    """
    print('Starting first')
     
    try:
        second(i)
    except AssertionError as e:
        print('Caught exception '+str(e))
    
     
    print('Ending first')
 

def second(i):
    """
    Our first function, it passes the argument i to third().  
    
    It contains the try-except block for ArithmeticError.
    Throws: AssertionError    i == 3
    Throws: ValueError        i == 4
    
    Parameter i: An int to control program flow
    Precondition: i is an int
    """
    print('Starting second')
     
    try:
        third(i)
    except ArithmeticError as e:
        print('Caught exception '+str(e))
    
     
    print('Ending second')

 
def third(i):
    """
    This function does nothing but throw exceptions.
    
    The Exception thrown depends on i.  Does nothing
    if i is 1.
    Throws: ArithmeticError   i == 2
    Throws: AssertionError    i == 3
    Throws: ValueError        i == 4
    
    Parameter i: An int to control program flow
    Precondition: i is an int
    """
    print('Starting third')
    
    if i == 1:
        pass
     
    if i == 2:
        # This exception is for bad arithmetic (i.e. divide by zero)
        y = 5/0
     
    if i == 3:
        # This exception is what assert statements create.
        raise AssertionError('My assert')
     
    if i == 4:
        # If a calculation produces a value you did not expect.
        raise ValueError('My value')
    
    print('Ending third')
