"""
A module showing how to read a JSON file.

While we have a function read_json built into the module introcs, this function
definition shows how it works.

Author: Walker M. White (wmw2)
Date:   November 10, 2022
"""
import json


def read_json(fname):
    """
    Returns the contents of the JSON file fname.

    This function reads the contents of the file fname. Assuming it is a properly
    encoded JSON file, it will convert this into a Python data value, which will
    either be a dictionary or a list.

    If the file does not exist, or is not a proper JSON file, this function will
    return None.

    Parameter fname: The file to read
    Precondition: fname is a string
    """
    assert isinstance(fname,str), repr(fname)+' is not a str'
    try:
        file = open(fname)
        data = file.read()
        file.close()

        result = json.loads(data)
        return result

    except FileNotFoundError:
        print('JSON file '+fname+' does not exist')
    except json.decoder.JSONDecodeError:
        print('JSON file '+fname+' is invalid')

    return None
