"""
A module to show how to use recursion with dictionaries

Author: Walker M. White
Date:   Oct 18, 2023
"""

# Global variable store the grade sheet
GRADES = {'jrs1':80,'jrs2':92,'wmw2':50,'abc1':95}


def max_grade(grades):
    """
    Returns the maximum grade in the grade dictionary

    Parameter grades: The dictionary of student grades
    Precondition: grades has netids as keys, ints as values
    """
    
    # WE CANNOT SLICE A DICTIONARY
    # We need to pull out keys and use a recursive helper
    netids = list(grades.keys())
    
    return max_grade_helper(netids,grades)


def max_grade_helper(netids,grades):
    """
    Returns the maximum grade among students in netids
    
    Parameter netids: The list of netids to check
    Precondition: netids is a list of keys in grades
    
    Parameter grades: The dictionary of student grades
    Precondition: grades has netids as keys, ints as values
    """
    # Our recursion is over netids, not grades
    
    # Process small data
    if len(netids) == 0:
        return 0
    elif len(netids) == 1:
        return grades[netids[0]]
    
    
    # Break it up into left and right
    left  = grades[netids[0]]
    right = max_grade_helper(netids[1:],grades)
    
    # Combine the answers
    return max(left,right)
