"""
Student grade example for dictionaries.

This module shows several a mutable function on dictionaries.

Author: Walker M. White
Date:   October 15, 2023
"""

# Global variable store the grade sheet
GRADES = {'jrs1':80,'jrs2':92,'wmw2':50,'abc1':95}


def add_bonus(grades,netids,bonus):
    """
    Gives bonus points to everyone in grades
    
    This is a PROCEDURE. It modifies the contents of grades. However, it only modifies 
    the values and does not add new keys
    
    Parameter grades: The dictionary of student grades
    Precondition: grades has netids as keys, ints as values.
    
    Parameter bonus: The extra credit bonus to award
    Precondition: bonus is an int
    """
    # No accumulator.  This is a procedure
    
    for student in netids:
        grades[student] = grades[student]+bonus
        

def merge(dict1,dict2):
    """
    Updates dict1 to include the contents of dict2.
    
    This is a PROCEDURE. It modifies the contents of dict1 .If a key from dict2 is 
    already in dict1, dict1 is associated with the maximum of the two values.
    
    Parameter dict1: The dictionary to modify
    Precondition: dict1 has str as keys, ints as values.
    
    Parameter dict2: The dictionary to copy
    Precondition: dict2 has str as keys, ints as values.
    """
    for key in dict2:
        # Looping over dict2; safe to modify dict1
        if key in dict1:
            dict1[key] = max(dict1[key],dict2[key])
        else:
            dict1[key] = dict2[key]
