"""
A unit test for second recursive lecture.

Author: Walker M. White (wmw2)
Date:   October 10, 2018
"""
import introcs
import morefun

def test_commafy():
    """
    Tests the (string-based) commafy function
    """
    print('Testing commafy')
    introcs.assert_equals('5',           morefun.commafy(5))
    introcs.assert_equals('12',          morefun.commafy(12))
    introcs.assert_equals('952',         morefun.commafy(952))
    introcs.assert_equals('999',         morefun.commafy(999))
    introcs.assert_equals('1,000',       morefun.commafy(1000))
    introcs.assert_equals('23,456',      morefun.commafy(23456))
    introcs.assert_equals('12,345,678',  morefun.commafy(12345678))
    introcs.assert_equals('912,345,678', morefun.commafy(912345678))


def test_exp_slow():
    """
    Tests the slow version of exponentiation
    """
    # Count the number of call frames
    print('Testing exp_slow')
    morefun.count_frames = 0
    introcs.assert_floats_equal(1.0,     morefun.exp_slow(2, 0))
    introcs.assert_floats_equal(2.0,     morefun.exp_slow(2, 1))
    introcs.assert_floats_equal(4.0,     morefun.exp_slow(2, 2))
    introcs.assert_floats_equal(16.0,    morefun.exp_slow(2, 4))
    introcs.assert_floats_equal(256.0,   morefun.exp_slow(2, 8))
    introcs.assert_floats_equal(65536.0, morefun.exp_slow(2, 16))
    print('Test used a total of '+str(morefun.count_frames)+' call frames')


def test_exp_fast():
    """
    Tests the fast version of exponentiation
    """
    # Count the number of call frames
    print('Testing exp_fast')
    morefun.count_frames = 0
    introcs.assert_floats_equal(1.0,     morefun.exp_fast(2, 0))
    introcs.assert_floats_equal(2.0,     morefun.exp_fast(2, 1))
    introcs.assert_floats_equal(4.0,     morefun.exp_fast(2, 2))
    introcs.assert_floats_equal(16.0,    morefun.exp_fast(2, 4))
    introcs.assert_floats_equal(256.0,   morefun.exp_fast(2, 8))
    introcs.assert_floats_equal(65536.0, morefun.exp_fast(2, 16))
    print('Test used a total of '+str(morefun.count_frames)+' call frames')


# Application Code
if __name__ == '__main__':
    test_commafy()
    test_exp_slow()
    test_exp_fast()
    print('Module morefun is working properly')
