"""
Unit test for recursive string functions.

Author: Walker M. White (wmw2)
Date:   October 10, 2017 (Python 3 Version)
"""
import introcs
import stringfun

def test_length():
    """
    Test the function length
    """
    introcs.assert_equals(0,  stringfun.length(''))
    introcs.assert_equals(1,  stringfun.length('e'))
    introcs.assert_equals(7,  stringfun.length('ceceddd'))
    introcs.assert_equals(15, stringfun.length('*0;jh=52y;jh=`5'))


def test_num_e():
    """
    Test the function num_e
    """
    introcs.assert_equals(0,  stringfun.num_e(''))
    introcs.assert_equals(1,  stringfun.num_e('e'))
    introcs.assert_equals(0,  stringfun.num_e('c'))
    introcs.assert_equals(2,  stringfun.num_e('ceceddd'))
    introcs.assert_equals(0,  stringfun.num_e('asdfasdfadsf'))


def test_deblank():
    """
    Test the function deblank
    """
    introcs.assert_equals('',   stringfun.deblank(''));
    introcs.assert_equals('',   stringfun.deblank(' '));
    introcs.assert_equals('B',  stringfun.deblank('B'));
    introcs.assert_equals('BG', stringfun.deblank('B G'));
    introcs.assert_equals('',   stringfun.deblank('         '));


def test_depunct():
    """
    Test the function depunct
    """
    introcs.assert_equals('',    stringfun.depunct('(@$*&@'));
    introcs.assert_equals('foo', stringfun.depunct('  f,o**o!!!'));
    introcs.assert_equals('foo', stringfun.depunct('f  (!*@&,.<>:\'  oo'));


def test_reverse():
    """
    Test the function reverse
    """
    introcs.assert_equals('',        stringfun.reverse(''));
    introcs.assert_equals('esrever', stringfun.reverse('reverse'));
    introcs.assert_equals('amanaplanacanalpanama',
                          stringfun.reverse('amanaplanacanalpanama'));
    introcs.assert_equals('a man a plan a canal panama',
                          stringfun.reverse('amanap lanac a nalp a nam a'));


# Application Code
if __name__ == '__main__':
    test_length()
    test_num_e()
    test_deblank()
    test_depunct()
    test_reverse()
    print('Module stringfun passed all tests.')
