"""
A module to show off the dangers of recursion.

What happens when you forget a base case.  Try this module out and see.

Author: Walker M. White (wmw2)
Date:   October 10, 2017 (Python 3 Version)
"""
import sys

# Allow us to go really deep
#sys.setrecursionlimit(999999999)

def factorial(n):
    """
    Returns: n!

    Parameter n: the number to compute
    Precondition: n is a nonnegative integer
    """
    #assert type(n) == int, repr(n)+' is not an int'     # get in the habit
    #assert n >= 0, repr(n)+' is negative'               # get in the habit

    #if n==0: # Base case
    #    return 1

    # Recursive case.
    return n*factorial(n-1)


# Call the function
factorial(1)
