"""
Models module for Froggit

This module contains the model classes for the Frogger game. Anything that you
interact with on the screen is model: the frog, the hedges, the lilypads, and 
so on.

The classes provided in this module are sufficient for the core game. You only
need to add classes to this module if you are adding extensions to the game.
And even then, it is not clear that you need new classes. Note how the Pad class
supports both logs and lilypads (because while they look different, they behave
the same). But if you want to add turtles that can submerge underneath the frog 
would probably need a custom model to track when the turtles are above water.

You are free to make any changes to these classes if you want. For example, if
you want to animate the frog movement, you might want to change the Frog class
so that it is a subclass of GSprite (which supports animation), instead of the
current class GImage.

If you are unsure about  whether to make a new class or not, please ask on 
Ed Discussions. We will answer.

# YOUR NAME(S) AND NETID(S) HERE
# DATE COMPLETED HERE
"""
from consts import *
from game2d import *

# PRIMARY RULE: Models are not allowed to access anything in any module other 
# than consts.py.  If you need extra information from the game level, then it 
# should be a parameter in your method.


class Frog(GImage): # You are permitted to change the parent class if you wish
    """
    A class representing the frog
    
    The frog contains the image (or sprite if you are doing animation)
    representing the frog. For a large part of the assignment, you do not need
    to write any code here. You can just rely on the parent class GImage to
    do all the work.
    
    However, we do need Frog to be its own class. This class will include 
    several new attributes, most notably for the code that you will use to 
    smoothly move the frog about the screen. For that reason, you will need a 
    new initializer to set up the frog attributes.
    
    Other methods in this class are up to you.  One notable method you might
    want to add is whether the frog is safe. As explained in the instructions,
    a frog is only safe if (1) the frog is at the exit or (2) both the left and
    right side of the frog are both safe on a Pad object (e.g. they collide 
    with a Pad).
    
    If you do any animation, you may want to override the draw method, but that
    is not required.
    
    NOTE: The attributes x and y in GImage are NOT hidden (they are properties
    and do not need getters/setters). You do not need getters and setters for
    attributes you inherit from GImage. You only need them for new attributes
    that you create.
    """
    pass
    # LIST ALL HIDDEN ATTRIBUTES HERE
    
    # GETTERS AND SETTERS (ONLY ADD IF YOU NEED THEM)
    
    # INITIALIZER TO SET THE FROG ATTRIBUTES
    
    # ADDITIONAL METHODS (DRAWING, COLLISIONS, MOVEMENT, ETC)


class Pad(GImage):  # You are permitted to change the parent class if you wish
    """
    A class representing something the frog can step on.
    
    While this class is called Pad, to keep the game simple, we are using this
    class to represent both lilypads and logs. The only difference between the
    two is the image used to display the pad -- and this is defined in the 
    level data file.
    
    For the most part, lilypads and logs are just drawn to the screen. There is
    no need for a lot of custom methods in this class. Indeed, the primary 
    reason the class exists is so that we can use isinstance to tell the 
    difference between a Pad and Hedge. With that said, you are unlikely to 
    need any methods here other than the initializer.
    
    NOTE: The attributes x and y in GImage are NOT hidden (they are properties
    and do not need getters/setters). You do not need getters and setters for
    attributes you inherit from GImage. You only need them for new attributes
    that you create.
    """
    pass
    # LIST ALL HIDDEN ATTRIBUTES HERE
    
    # GETTERS AND SETTERS (ONLY ADD IF YOU NEED THEM)
    
    # INITIALIZER TO SET THE ATTRIBUTES
    
    # ADDITIONAL METHODS AS NEEDED


class Hedge(GImage):  # You are permitted to change the parent class if you wish
    """
    A class representing terrain that blocks the frog.
    
    A hedge blocks frog movement. It does not kill the frog, like drowning does.
    But it does prevent the frog from moving in a certain direction. When 
    combined with strong currents, this can create some interesting challenges.
    
    While it is not required, you may want to write code in this class to 
    determine whether a hedge blocks the frog. Note that, to block a frog, we 
    only require that one side (not both) of the frog overlap with this hedge.
    
    NOTE: The attributes x and y in GImage are NOT hidden (they are properties
    and do not need getters/setters). You do not need getters and setters for
    attributes you inherit from GImage. You only need them for new attributes
    that you create.
    """
    pass
    # LIST ALL HIDDEN ATTRIBUTES HERE
    
    # GETTERS AND SETTERS (ONLY ADD IF YOU NEED THEM)
    
    # INITIALIZER TO SET THE ATTRIBUTES
    
    # ADDITIONAL METHODS (e.g. COLLISIONS) AS NEEDED


class Exit(GImage):  # You are permitted to change the parent class if you wish
    """
    A class representing one of the required exits.
    
    An exit is similar to a Pad object in that a frog can safely step on it.
    However, when a frog steps on an exit, it stops there. And the game moves
    to the next frog. An exit can only have one frog on it, and the game is won
    when all exits have a frog.
    
    If an exit already contains a frog, then it acts as a hedge, blocking any 
    other frog from moving through it. Because the behavior of the exit depends
    on whether or not it has a frog, you are definitely going to want to add a
    new attribute to track that. You also want to override the draw method to
    show a frog at the exit if it is occupied.
    
    NOTE: The attributes x and y in GImage are NOT hidden (they are properties
    and do not need getters/setters). You do not need getters and setters for
    attributes you inherit from GImage. You only need them for new attributes
    that you create.
    """
    pass
    # LIST ALL HIDDEN ATTRIBUTES HERE
    
    # GETTERS AND SETTERS (ONLY ADD IF YOU NEED THEM)
    
    # INITIALIZER TO SET THE ATTRIBUTES
    
    # ADDITIONAL METHODS (DRAWING, COLLISIONS, ETC)


# IF YOU NEED ADDITIONAL MODEL CLASSES, THEY GO HERE

