"""
A module to draw cool shapes with the introcs Turtle.

The module can be run as a script to show off the various functions. Unimplemented 
functions will do nothing.

YOUR NAME(S) AND NETID(S) HERE
DATE COMPLETED HERE
"""
from introcs.turtle import Window, Turtle, Pen
import introcs  # For the RGB (color) objects
import math     # For the math computations


################# Helpers for Precondition Verification #################

def is_number(x):
    """
    Returns: True if value x is a number; False otherwise.
    
    Parameter x: the value to check
    Precondition: NONE (x can be any value)
    """
    return type(x) in [float, int]


def is_window(w):
    """
    Returns: True if w is a introcs Window; False otherwise.
    
    Parameter w: the value to check
    Precondition: NONE (w can be any value)
    """
    return type(w) == Window


def is_valid_color(c):
    """
    Returns: True c is a valid turtle color; False otherwise
    
    Parameter c: the value to check
    Precondition: NONE (c can be any value)
    """
    if type(c) == str:
        return introcs.is_tkcolor(c) or introcs.is_webcolor(c)
    # else
    return type(c) == introcs.RGB or type(c) == introcs.HSV


def is_valid_speed(sp):
    """
    Returns: True if sp is an int in range 0..10; False otherwise.
    
    Parameter sp: the value to check
    Precondition: NONE (sp can be any value)
    """
    return (type(sp) == int and 0 <= sp and sp <= 10)


def is_valid_length(side):
    """
    Returns: True if side is a number >= 0; False otherwise.
    
    Parameter side: the value to check
    Precondition: NONE (side can be any value)
    """
    return (is_number(side) and 0 <= side)


def is_valid_iteration(n):
    """
    Returns: True if n is an int >= 1; False otherwise.
    
    Parameter n: the value to check
    Precondition: NONE (n can be any value)
    """
    return (type(n) == int and 1 <= n)


def is_valid_depth(d):
    """
    Returns: True if d is an int >= 0; False otherwise.
    
    Parameter d: the value to check
    Precondition: NONE (d can be any value)
    """
    return (type(d) == int and d >= 0)


def is_valid_turtlemode(t):
    """
    Returns: True t is a Turtle with drawmode True; False otherwise.
    
    Parameter t: the value to check
    Precondition: NONE (t can be any value)
    """
    return (type(t) == Turtle and t.drawmode)


def is_valid_penmode(p):
    """
    Returns: True t is a Pen with solid False; False otherwise.
    
    Parameter p: the value to check
    Precondition: NONE (p can be any value)
    """
    return (type(p) == Pen and not p.solid)


def report_error(message, value):
    """
    Returns: An error message about the given value.
    
    This is a function for constructing error messages to be used in assert 
    statements. We find that students often introduce bugs into their assert 
    statement messages, and do not find them because they are in the habit of 
    not writing tests that violate preconditions.
    
    The purpose of this function is to give you an easy way of making error 
    messages without having to worry about introducing such bugs. Look at  the 
    function draw_two_lines for the proper way to use it.
    
    Parameter message: The error message to display
    Precondition: message is a string
    
    Parameter value: The value that caused the error
    Precondition: NONE (value can be anything)
    """
    return message+': '+repr(value)




#################### DEMO: Two lines ####################

def draw_two_lines(w,sp):
    """
    Draws two lines on to window w.
    
    This function clears w of any previous drawings. Then, in the middle of the 
    window w, this function draws a green line 100 pixels to the east, and then 
    a blue line 200 pixels to the north. It uses a new turtle that moves at 
    speed sp, 0 <= sp <= 10, with 1 being slowest and 10 fastest (and 0 being 
    "instant").
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    This procedure asserts all preconditions.
    
    Parameter w: The window to draw upon.
    Precondition: w is a introcs Window object.
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # Assert the preconditions
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # Clear the window first!
    w.clear()
    
    # Create a turtle and draw
    t = Turtle(w)
    t.speed = sp
    t.color = 'green'
    t.forward(100) # draw a line 100 pixels in the current direction
    t.left(90)     # add 90 degrees to the angle
    t.color = 'blue'
    t.forward(200)
    
    # This is necessary if speed is 0!
    t.flush()




#################### TASK 1: Triangle ####################

def draw_triangle(t, s, c):
    """
    Draws an equilateral triangle of side s and color c at current position.
    
    The direction of the triangle depends on the current facing of the turtle. 
    If the turtle is facing west, the triangle points up and the turtle starts 
    and ends at the east end of the base line.
    
    WHEN DONE, THE FOLLOWING TURTLE ATTRIBUTES ARE THE SAME AS IT STARTED: 
    position (x and y, within round-off errors), heading, color, and drawmode. 
    If you changed any of these in the function, you must change them back.
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    This procedure asserts all preconditions.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter s: The length of each triangle side
    Precondition: s is a valid side length (number >= 0)
    
    Parameter c: The triangle color
    Precondition: c is a valid turtle color (see the helper function above)
    """
    # Assert the preconditions
    assert is_valid_turtlemode(t), report_error('Invalid turtle mode', t)
    assert is_valid_length(s), report_error('Invalid side length', s)
    assert is_valid_color(c), report_error('Invalid color', c)
    
    # Hint: each angle in an equilateral triangle is 60 degrees.
    # Note: In this function, DO NOT save the turtle position and heading
    # in the beginning and then restore them at the end. The turtle moves
    # should be such that the turtle ends up where it started and facing
    # in the same direction, automatically.
    
    # Also, 3 lines have to be drawn. Does this suggest a for loop that
    # processes the range 0..2?
    pass




#################### TASK 2: Hexagon ####################

def draw_hex(t, s):
    """
    Draws six triangles using the color 'magenta' to make a hexagon.
    
    The triangles are equilateral triangles, using draw_triangle as a helper. 
    The drawing starts at the turtle's current position and heading. The middle 
    of the hexagon is the turtle's starting position.
    
    WHEN DONE, THE FOLLOWING TURTLE ATTRIBUTES ARE THE SAME AS IT STARTED: 
    position (x and y, within round-off errors), heading, color, and drawmode. 
    If you changed any of these in the function, you must change them back.
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    This procedure asserts all preconditions.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter s: The length of each triangle side
    Precondition: s is a valid side length (number >= 0)
    """
    # Assert the preconditions
    assert is_valid_turtlemode(t), report_error('Invalid turtle mode', t)
    assert is_valid_length(s), report_error('Invalid side length', s)

    # Note: Do not save any of the turtle's properties and then restore them
    # at the end. Just use 6 calls on procedures drawTriangle and t.left. Test
    # the procedure to make sure that t's final location and heading are the
    # same as t's initial location and heading (except for roundoff error).
    pass



#################### Task 3: Radiating Shapes ####################

# DO NOT MODIFY (Helper for Tasks 3B and 3C)
def draw_polygon(t, radius, n):
    """
    Draws an n-sided regular polygon with the given radius.
    
    The polygon will centered at the current turtle position. The first vertex 
    of the polygon will be radius units along the current turtle heading.
    
    WHEN DONE, THE FOLLOWING TURTLE ATTRIBUTES ARE THE SAME AS IT STARTED: 
    position (x and y, within round-off errors), heading, color, speed, visible, 
    and drawmode. There is no need to restore these.
    
    This procedure asserts all preconditions.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter radius: The polygon radius
    Precondition: radius is a valid side length (number >= 0)
    
    Parameter n: The number of sides of each polygon
    Precondition: n is an int >= 1
    """
    # Precondition assertions omitted
    
    # Remember the initial settings
    drawmode = t.drawmode
    heading  = t.heading
    
    # Compute the exterior angle between edges
    ang = 360.0/n
    side = 2*radius*math.sin(math.pi/n)
    
    # Move the turtle to the starting vertex and angle
    t.drawmode = False
    t.forward(radius)
    t.left(90+ang/2)
    t.drawmode = drawmode
    
    # t is in position, so it is time to draw
    for _ in range(n):
        t.forward(side)
        t.left(ang)
    
    # Restore the turtle
    t.drawmode = False
    t.right(90+ang/2)
    t.backward(radius)
    t.drawmode = drawmode


#################### Task 3A: Spirals ####################

def draw_spiral(w, side, ang, n, sp):
    """
    Draws a spiral using draw_spiral_helper(t, side, ang, n, sp)
    
    This function clears the window and makes a new turtle t. This turtle starts 
    in the middle of the canvas facing south (NOT the default east). It then 
    calls the function draw_spiral_helper(t, side, ang, n, sp). When it is done, 
    the turtle is left hidden (visible is False).
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    This procedure asserts all preconditions.
    
    Parameter w: The window to draw upon.
    Precondition: w is a introcs Window object.
    
    Parameter side: The length of each spiral side
    Precondition: side is a valid side length (number >= 0)
    
    Parameter ang: The angle of each corner of the spiral
    Precondition: ang is a number
    
    Parameter n: The number of edges of the spiral
    Precondition: n is a valid number of iterations (int >= 1)
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_length(side), report_error('side is not a valid length',side)
    assert is_valid_iteration(n), report_error('n is not a valid number of iterations',side)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # HINT: Remember to flush at the end for speed 0
    pass


def draw_spiral_helper(t, side, ang, n, sp):
    """
    Draws a spiral of n lines at the current position and heading.
    
    The spiral begins at the current turtle position and heading, turning ang 
    degrees to the right after each line. Line 0 is side pixels long. Line 1 is 
    2*side pixels long, and so on. Hence each Line i is (i+1)*side pixels long. 
    The lines alternate between magenta, green, blue, and red, in that order, 
    with the first one magenta.
    
    WHEN DONE, THE FOLLOWING TURTLE ATTRIBUTES ARE THE SAME AS IT STARTED: 
    color, speed, visible, and drawmode. However, the final position and heading 
    may be different. If you changed any of these four in the function, you must 
    change them back.
    
    This procedure asserts all preconditions.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter side: The length of each spiral side
    Precondition: side is a valid side length (number >= 0)
    
    Parameter ang: The angle of each corner of the spiral
    Precondition: ang is a number
    
    Parameter n: The number of edges of the spiral
    Precondition: n is a valid number of iterations (int >= 1)
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_valid_turtlemode(t), report_error('Invalid turtle mode', t)
    assert is_valid_length(side), report_error('side is not a valid length',side)
    assert is_valid_iteration(n), report_error('n is not a valid number of iterations',side)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # IMPLEMENT ME
    pass


#################### TASK 3B: Polygon Vortex ####################

def draw_vortex(w, r1, r2, n, k, sp):
    """
    Draws a polygonal vortex of k polygons with initial radius r1 and final radius r2 
    
    This function clears the window and makes a new turtle t. This turtle starts 
    in the middle of the canvas facing west (NOT the default east). It then 
    calls the function draw_vortex_helper(t, r1, r2, n, k, sp). The function 
    draws with a visible turtle, but the turtle if left hidden (visible is 
    False) when it is done.
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    This procedure asserts all preconditions.
    
    Parameter w: The window to draw upon.
    Precondition: w is a introcs Window object.
    
    Parameter r1: The radius of the first polygon in the vortex
    Precondition: r1 is a valid side length (number >= 0) and r1 <= r2

    Parameter r2: The radius of the last polygon in the vortex
    Precondition: r2 is a valid side length (number >= 0) and r1 <= r2
    
    Parameter n: The number of sides of each polygon
    Precondition: n is an int >= 3
    
    Parameter k: The number of polygons to draw
    Precondition: k is an int >= 2
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_length(r1), report_error('r1 is not a valid length',r1)
    assert is_valid_length(r2), report_error('r2 is not a valid length',r2)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # HINT: Remember to flush at the end for speed 0
    pass


def draw_vortex_helper(t, r1, r2, n, k, sp):
    """
    Draws a polygon vortex of k polygons with initial radius r1 and final radius r2 
    
    The polygons are drawn by turtle t, centered at the current position. The 
    initial polygon is drawn with radius r1 and the current turtle heading. 
    Later polygons are rotated by 360/k degrees to the left, and uniformly 
    increase in size so that the final polygon has radius r2. The polygons 
    alternate between green, blue, and red, in that order, with the first one 
    green.
    
    At the end, ALL ATTRIBUTES of the turtle are the same as they were in the 
    beginning (within roundoff errors). If you change any attributes of the 
    turtle. then you must restore them. Look at the helper draw_polygon for more 
    information on what might be changed.
    
    This procedure asserts all preconditions.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter r1: The radius of the first polygon in the vortex
    Precondition: r1 is a valid side length (number >= 0) and r1 <= r2

    Parameter r2: The radius of the last polygon in the vortex
    Precondition: r2 is a valid side length (number >= 0) and r1 <= r2
    
    Parameter n: The number of sides of each polygon
    Precondition: n is an int >= 3
    
    Parameter k: The number of polygons to draw
    Precondition: k is an int >= 2
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_valid_turtlemode(t), report_error('Invalid turtle mode', t)
    assert is_valid_length(r1), report_error('r1 is not a valid length',r1)
    assert is_valid_length(r2), report_error('r2 is not a valid length',r2)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # HINT: Start with a polygon of radius r1. At each step, increase the radius
    # by (r2-r1)/(k-1), and rotate the polygon 360/k degrees
    pass




#################### TASK 3C: Color Orbit ####################

def draw_orbit(w, r1, r2, n, k, sp):
    """
    Draws polygons using multi_polygons_helper(t, side, k, n, sp)
    
    This function clears the window and makes a new turtle t. This turtle starts 
    in the middle of the canvas facing north (NOT the default east). It then 
    calls the function draw_orbit_helper(t, r1, r2, n, k, sp). The function 
    draws with a visible turtle, but the turtle if left hidden (visible is 
    False) when it is done. 
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    This procedure asserts all preconditions.
    
    Parameter w: The window to draw upon.
    Precondition: w is a introcs Window object.
    
    Parameter r1: The distance from the orbit center to the center of each polygon
    Precondition: r1 is a valid side length (number >= 0) and r1 >= r2

    Parameter r2: The radius of each polygon in the orbit
    Precondition: r2 is a valid side length (number >= 0) and r1 >= r2

    Parameter n: The number of sides of each polygon
    Precondition: n is an int >= 3
    
    Parameter k: The number of polygons to draw
    Precondition: k is an int >= 1
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_length(r1), report_error('r1 is not a valid length',r1)
    assert is_valid_length(r2), report_error('r2 is not a valid length',r2)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
   
    # HINT: Remember to flush at the end for speed 0
    pass


def draw_orbit_helper(t, r1, r2, n, k, sp):
    """
    Draws k n-sided polygons of side length s.
    
    This function draws an orbit of k polygons. At each step, the turtle moves 
    forward r1 to draw a n-sided polygon, and then backwards by r1 again.  The 
    move to and from each polygon should not draw a line (so drawmode is False 
    when going forward and backward). The position of each polygon is rotated 
    360.0/k about the center of the orbit. In addition, each polygon has HSV 
    color (t.heading % 360.0, 1.0, 1.0).
    
    At the end, ALL ATTRIBUTES of the turtle are the same as they were in the 
    beginning (within roundoff errors). If you change any attributes of the 
    turtle. then you must restore them. Look at the helper draw_polygon for more 
    information on what might be changed.
    
    This procedure asserts all preconditions.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter r1: The distance from the orbit center to the center of each polygon
    Precondition: r1 is a valid side length (number >= 0) and r1 >= r2
    
    Parameter r2: The radius of each polygon in the orbit
    Precondition: r2 is a valid side length (number >= 0) and r1 >= r2
    
    Parameter n: The number of sides of each polygon
    Precondition: n is an int >= 3
    
    Parameter k: The number of polygons to draw
    Precondition: k is an int >= 1
    
    Parameter sp: The turtle speed.
    Precondition: sp is a valid turtle speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_valid_turtlemode(t), report_error('Invalid turtle mode', t)
    assert is_valid_length(r1), report_error('r1 is not a valid length',r1)
    assert is_valid_length(r2), report_error('r2 is not a valid length',r2)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # Hint: draw_polygon does a lot of the work, but the turtle must start in position
    # You need to move the turtle to position without drawing a line (e.g. drawmode False)
    # 1. Rotate the turtle to the correct angle
    # 2. Move the turtle forward by r1 without drawing
    # 3. Draw the polygon
    # 4. Move the turtle backward r1 without drawing
    # In addition, the HSV color should be (t.heading % 360.0, 1, 1) at each step
    pass




############### TASK 4: Recursive Shapes ################

#################### TASK 4A: H-Tree ####################

def htree(w, side, width, d, sp):
    """
    Draws a H-tree with the given side length, stroke width, and depth d.
    
    This function clears the window and makes a new graphics pen p. This pen 
    starts in the middle of the canvas at (0,0). It draws by calling the
    function htree_helper(p, 0, 0, side, width, d). The pen is visible during 
    drawing and should be set to hidden at the end.
    
    The pen should have fill color 'yellow' and edge color 'blue'.
    
    REMEMBER: You need to flush the pen if the speed is 0.
    
    Parameter w: The window to draw upon.
    Precondition: w is a Window object.
    
    Parameter side: The side length of the h-tree
    Precondition: side is a valid side length (number >= 0)
    
    Parameter width: The stroke width of the h-tree
    Precondition: width is a valid side length (number >= 0)
   
    Parameter sp: The drawing speed.
    Precondition: sp is a valid turtle/pen speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # HINT: Remember to flush at the end for speed 0
    pass


def htree_helper(p, x, y, side, width, d):
    """
    Draws a H-tree  with the given side length, stroke width and depth d, centered at (x, y).
    
    The initial H is drawn with fill_h, centered at (x,y). For depths higher 
    than 0, this function draws additional H-trees at the corners of the 
    original H. Note that, because of the stroke width, the function fill_h will 
    expand the drawing around the corners of the H. The recursive shapes should 
    ignore the width when computing their position.
    
    Note that this shape is technically undefined if 2*width > side. However, 
    we are not enforcing that as a precondition.
    
    Parameter p: The graphics pen
    Precondition: p is a Pen with fill attribute False.
    
    Parameter x: The x-coordinate of the tree center
    Precondition: x is a number
    
    Parameter y: The y-coordinate of the tree center
    Precondition: y is a number
    
    Parameter side: The side length of the h-tree
    Precondition: side is a valid side length (number >= 0)
    
    Parameter width: The stroke width of the h-tree
    Precondition: width is a valid side length (number >= 0)
    
    Parameter d: The recursive depth of the triangle
    Precondition: d is a valid depth (int >= 0)
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_valid_penmode(p), report_error('Invalid pen mode', p)
    
    # IMPLEMENT ME
    pass


# DO NOT MODIFY
def fill_h(p, x, y, side, width):
    """
    Creates a solid H with dimension side and stroke width at position (x,y)
    
    The width is the stroke width of the legs and cross-bar of the H. Note that 
    this shape is technically undefined if 2*width > side. However, we are not 
    enforcing that as a precondition.
    
    This procedure asserts all preconditions. The pen is left at position (x,y) 
    when done.
    
    Parameter p: The graphics pen
    Precondition: p is a Pen with fill attribute False.
    
    Parameter x: The x-coordinate of the tree center
    Precondition: x is a number
    
    Parameter y: The y-coordinate of the tree center
    Precondition: y is a number
    
    Parameter side: The side length of the h-tree
    Precondition: side is a valid side length (number >= 0)
    
    Parameter width: The stroke width of the h-tree
    Precondition: width is a valid side length (number >= 0)
    """
    # Precondition assertions omitted
    
    p.move(x,y-width/2)
    p.solid = True
    p.drawLine(side/2-width/2,0)
    p.drawLine(0,-side/2)
    p.drawLine(width,0)
    p.drawLine(0,side+width)
    p.drawLine(-width,0)
    p.drawLine(0,-side/2)
    p.drawLine(-side+width,0)
    p.drawLine(0,side/2)
    p.drawLine(-width,0)
    p.drawLine(0,-side-width)
    p.drawLine(width,0)
    p.drawLine(0,side/2)
    p.drawLine(side/2,0)
    p.solid = False
    
    p.move(x,y)


#################### TASK 4B: Jerusalem Cross ####################

def cross(w, side, d, sp):
    """
    Draws a Jerusalm cross with dimension side and depth d.
    
    This function clears the window and makes a new graphics pen p. This pen 
    starts in the middle of the canvas at (0,0). It draws by calling the 
    function cross_helper(p, 0, 0, side, d). The pen is visible during drawing 
    and should be set to hidden at the end.
    
    The pen should have both fill color and edge color 'red'.
    
    REMEMBER: You need to flush the pen if the speed is 0.
    
    Parameter w: The window to draw upon.
    Precondition: w is a Window object.
    
    Parameter side: The side length of the Jerusalem cross
    Precondition: side is a valid side length (number >= 0)
    
    Parameter d: The recursive depth of the cross
    Precondition: d is a valid depth (int >= 0)
    
    Parameter sp: The drawing speed.
    Precondition: sp is a valid turtle/pen speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_length(side), report_error('side is not a valid length',side)
    
    # HINT: Remember to flush at the end for speed 0
    pass


def cross_helper(p, x, y, side, d):
    """
    Draws a Jerusalem cross of dimension side and depth d centered at (x,y)
    
    The cross is drawn with the current pen color and visibility attribute. 
    Follow the instructions on the course website to recursively draw the 
    Jerusalem cross. Use the provided helper fill_square to create the requisite 
    squares.
    
    Parameter p: The graphics pen
    Precondition: p is a Pen with fill attribute False.
    
    Parameter x: The x-coordinate of the cross center
    Precondition: x is a number
    
    Parameter y: The y-coordinate of the cross center
    Precondition: y is a number
    
    Parameter side: The side length of the Jerusalem cross
    Precondition: side is a valid side length (number >= 0)
    
    Parameter d: The recursive depth of the cross
    Precondition: d is a valid depth (int >= 0)
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_valid_penmode(p), report_error('Invalid pen mode', p)
    
    # IMPLEMENT ME
    pass


# DO NOT MODIFY
def fill_square(p, x, y, side):
    """
    Fills a square of length side with center (x, y) using pen p.
    
    This procedure asserts all preconditions. The pen is left at position (x,y) 
    when done.
    
    Parameter p: The graphics pen
    Precondition: p is a Pen with solid attribute False.
    
    Parameter x: The x-coordinate of the square center
    Precondition: x is a number
    
    Parameter y: The y-coordinate of the square center
    Precondition: y is a number
    
    Parameter side: The side length of the square
    Precondition: side is a valid side length (number >= 0)
    """
    # Precondition assertions omitted
    
    # Move to the center and draw
    p.move(x - side/2, y - side/2)
    p.solid = True
    p.drawLine(    0,  side)
    p.drawLine( side,     0)
    p.drawLine(    0, -side)
    p.drawLine(-side,     0)
    p.solid = False
    p.move(x, y)


#################### TASK 5: Gosper Island ####################

def gosper(w, side, d, sp):
    """
    Draws a Gosper island with the given side length and depth d.
    
    This function clears the window and makes a new turtle T. This turtle starts 
    with the default heading in the upper left corner of a hexagon centered at 
    (0,0) with side length of each edge (see the instructions for how to compute 
    this position). It draws by calling gosper_edge(t,side,d) six times, turning 
    60 degrees to the right after each call.
    
    The turtle should be visible while drawing, but hidden at the end. The 
    turtle color is 'cornflower blue'.
    
    REMEMBER: You need to flush the turtle if the speed is 0.
    
    Parameter w: The window to draw upon.
    Precondition: w is a Window object.
    
    Parameter side: The side-length of the island
    Precondition: side is a valid side length (number >= 0)
    
    Parameter d: The recursive depth of the island
    Precondition: d is a valid depth (int >= 0)
    
    Parameter sp: The drawing speed.
    Precondition: sp is a valid turtle/pen speed.
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_window(w), report_error('w is not a valid window',w)
    assert is_valid_speed(sp), report_error('sp is not a valid speed',sp)
    
    # HINT: Remember to flush at the end for speed 0
    pass


def gosper_edge(t, side, d):
    """
    Draws a single Gosper edge with and depth d at the current position and angle.
    
    The edge is draw with the current turtle color. You should make no 
    assumptions of the current angle of the turtle (e.g. use left and right to 
    turn; do not set the heading).
    
    WHEN DONE, THE FOLLOWING TURTLE ATTRIBUTES ARE THE SAME AS IT STARTED: 
    color, speed, heading, visible, and drawmode. However, the final position 
    may be different. If you changed any of these four in the function, you 
    must change them back.
    
    Parameter t: The drawing Turtle
    Precondition: t is a Turtle with drawmode True.
    
    Parameter side: The length of each Gosper edge
    Precondition: side is a valid side length (number >= 0)
    
    Parameter d: The recursive depth of the edge
    Precondition: d is a valid depth (int >= 0)
    """
    # ARE THESE ALL OF THE PRECONDITIONS?
    assert is_valid_turtlemode(t), report_error('Invalid turtle mode', t)
    
    # HINT: Look closely at the picture from the instructions.
    # Depth 0 is a straight-line, while higher depths break into three parts
    # Compute theta and the segment length from the provided formulas
    pass