"""
Unit test for multiple modules

This module illustrates what a proper unit test should look like. Each function being
tested has its own test procedure.

It also has a segment of "script code" that invokes the test procedure when
this module is run as an script.

Author: Walker M. White
Date:   February 14, 2019
"""
import introcs          # introcs assert functions
import partial as name  # function to be tested


def test_last_name_first():
    """
    Test procedure for last_name_first
    """
    print('Testing last_name_first')
    
    # One blank space
    result = name.last_name_first('Walker White')
    introcs.assert_equals('White, Walker',result)
    
    # Multiple blank spaces
    result = name.last_name_first('Walker     White')
    introcs.assert_equals('White, Walker',result)


# Script code
if __name__ == '__main__':      # Execute code below only if run as a script
    test_last_name_first()
    print('The module name passed all tests.')
