"""
The debug version of the module name

This module is exactly like the module name, except that we have added print
statements after every assignment. These allow us to 'visualize" the program
while it is running, and hence isolate the error. However, they will eventually
need to be removed when we find the error.

Author: Walker M. White
Date:   September 10, 2019
"""

def last_name_first(n):
    """
    Returns a copy of n but in the form 'last-name, first-name'
    
    Parameter n: the person's name
    Precondition: n is in the form 'first-name last-name' with one or more 
    blanks between the two names, and no spaces in `first-name` or `last-name`
    """
    
    print("Starting last_name_first('"+n+"')")
    
    end_first = n.find(' ')
    print('end_first is "'+str(end_first)+'"')
    
    first = n[:end_first]
    print('first is "'+str(first)+'"')
    
    last  = n[end_first+1:]
    print('last is "'+str(last)+'"')
    
    print("Finishing last_name_first('"+n+"')")
    
    print() # prints a blank line
    return last+', '+first

