def subcat_names(c):
    """Returns a list of all the names of subcategories for category `c`.
    (Order doesn't matter. Do NOT include the name of `c` itself.

    A category is a list of two items:
        * a non-empty string, like "Animal".
        * a (possibly empty) list of subcategories.

    Example: 
        cdh = ["Dwarf Hamster", []]     means subcat_names(cdh) --> []
        h = ["Hamster", [cdh]]          means subcat_names(h) --> ["Dwarf Hamster"]
        fi = ["Fish", []]               
        fo = ["Fowl", []]
        a = ["Animal", [fi, fo, h]]     means subcat_names(a) --> 
                                         ["Fish", "Fowl", Hamster", "Dwarf Hamster"] 

    You don't need to know this, but a full listing of `a` is: 
    ['Animal', [['Fish', []], ['Fowl', []], ['Hamster', [['Dwarf Hamster', []]]]]].
    """

if __name__ == '__main__':
    cdh = ["Dwarf Hamster", []]
    h = ["Hamster", [cdh]]
    fi = ["Fish", []]
    fo = ["Fowl", []]
    a = ["Animal", [fi, fo, h]]

    testcases = [[a, ["Fowl", "Fish", "Hamster", "Dwarf Hamster"]],
                [fo, []], 
                [fi, []],
                [h, ["Dwarf Hamster"]], 
                [cdh, []]
                ]

    for item in testcases:
        cat = item[0]
        expected = set(item[1]) # use sets to ignore order

        result = set(subcat_names(cat))
        assert result == expected, \
        "Bad result on " + cat[0] + ": " + str(result)

