def peel(markers, text):
    """Returns a new string where the `markers` have been removed from the 
       beginning and end of `text`

    Examples:
      peel( "()",   "(abc)" )    -->  "abc"      

      peel( "()",   "(1(+)1)" )  -->  "1(+)1"      

      peel( "<()>", "<(>.<)>" )  -->  ">.<"

      peel( "ab",   "ab" )       -->  ""
          
      Preconditions:
        markers: string of even length (0 is allowed)
        text: any-length string that starts w/ 1st half of `markers`, ends w/ 2nd half.
     """
    # REMINDER: in a slice expression like s[n:m], n and m must be ints, not floats
    # BEGIN REMOVE
    marker_len = len(markers)//2
    text_len = len(text)

    # This solution avoids using rindex/rfind by subtracting from len(text).
    return text[marker_len:text_len-marker_len]
    # END REMOVE

# BEGIN REMOVE
# Alternate solution
def peel2(markers, text):
     m1= markers[:len(markers) //2]
     m2 = markers[len(markers)//2:]
     start_inside = text.index(m1)+len(m1)
     end_inside = text.rindex(m2)-1
     return text[start_inside:end_inside+1]

# Another alternate solution
def peel3(markers, text):
     m1= markers[:len(markers) //2]
     m2 = markers[len(markers)//2:]
     start_inside = text.index(m1)+len(m1)
     start_outside = text.rindex(m2)
     return text[start_inside:start_outside]


# BEGIN REMOVE
if __name__ == '__main__':
     import cornellasserts as ca
     
     testcases = [["()", "(1(+)1)", "1(+)1"],
                  ["()", "(1+1)", "1+1"],
                  ["<()>", "<(>.<)>", ">.<"],
                  ["ab", "ab", ""],
                  [ "", "ab", "ab"],
                  ['ab', "aaabbb", "aabb"]
                  ]


     for t in testcases:
          markers = t[0]
          text = t[1]
          expected = t[2]
          print("Testing peel("+repr(markers)+", "+str(text)+")")
          result = peel(markers, text)
          assert result == expected, \
            "should have returned "+repr(expected)+" but got "+repr(result)

     print("Tests ran without crashing, thing seem OK!")
# END REMOVE
