def swap2(a_list, j, k):
    """Modifies a_list by swapping the two elements of a_list starting
    at index j with the 2 entries of a_list starting at index k.

    Examples:
      swap2([100, 101, 102, 103, 104, 105, 106, 107, 108, 109], 1, 6)
         changes a_list to
            [100, 106, 107, 103, 104, 105, 101, 102, 108, 109]
                  --------                 --------

      swap2([100, 101, 102, 103, 104, 105, 106, 107, 108, 109], 0, 4)
         changes a_list to
            [104, 105, 102, 103, 100, 101, 106, 107, 108, 109]
             --------            --------

      swap2(['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'], 0, 4)
         changes a_list to
            ['e', 'f', 'c', 'd', 'a', 'b', 'g', 'h', 'i', 'j']
             --------            --------

    Preconditions:
       j and k are valid indices (positive, < len(a_list))
       j + 2 <= k  (the elements you're swapping don't overlap in a_list)
       k + 2 <= len(a_list)                                          """
    # STUDENTS: loops are NOT ALLOWED (or needed)
    # BEGIN REMOVE
    temp1 = a_list[j]
    temp2 = a_list[j+1]
    a_list[j] = a_list[k]
    a_list[j+1] = a_list[k+1]
    a_list[k] = temp1
    a_list[k+1] = temp2
    # END REMOVE

# BEGIN REMOVE
if __name__ == '__main__':
     
     testcases = [[[100, 101, 102, 103, 104, 105, 106, 107, 108, 109], 1, 6,
                    [100, 106, 107, 103, 104, 105, 101, 102, 108, 109]],
                  [['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'], 0, 4,
                   ['e', 'f', 'c', 'd', 'a', 'b', 'g', 'h']]]

     for t in testcases:
          a_list = t[0]
          j = t[1]
          k = t[2]
          expected = t[3]
          print("Testing swap2("+repr(a_list)+", "+ str(j) +", " + str(k)+")")
          result = swap2(a_list, j, k)
          assert expected == a_list, \
            "a_list should be "+repr(expected)+" but is "+repr(a_list)
          assert result == None, \
            "swap2 should return None but returned "+repr(result)

     print("Tests ran without crashing")
# END REMOVE

